/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis;

import com.mystic.atlantis.TagsInit;
import com.mystic.atlantis.blocks.base.ExtendedBlockEntity;
import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.dimension.DimensionAtlantis;
import com.mystic.atlantis.entities.CoconutCrabEntity;
import com.mystic.atlantis.entities.CrabEntity;
import com.mystic.atlantis.entities.JellyfishEntity;
import com.mystic.atlantis.entities.LeviathanEntity;
import com.mystic.atlantis.entities.SeahorseEntity;
import com.mystic.atlantis.entities.ShrimpEntity;
import com.mystic.atlantis.entities.StarfishEntity;
import com.mystic.atlantis.entities.StarfishZomEntity;
import com.mystic.atlantis.feature.AtlantisFeature;
import com.mystic.atlantis.init.AtlantisEntityInit;
import com.mystic.atlantis.init.AtlantisGroupInit;
import com.mystic.atlantis.init.AtlantisModifierInit;
import com.mystic.atlantis.init.AtlantisSoundEventInit;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.EffectsInit;
import com.mystic.atlantis.init.EnchantmentInit;
import com.mystic.atlantis.init.FluidInit;
import com.mystic.atlantis.init.FluidTypesInit;
import com.mystic.atlantis.init.ItemInit;
import com.mystic.atlantis.init.MenuTypeInit;
import com.mystic.atlantis.init.POITypesInit;
import com.mystic.atlantis.init.PaintingVariantsInit;
import com.mystic.atlantis.init.RecipesInit;
import com.mystic.atlantis.init.TileEntityInit;
import com.mystic.atlantis.init.ToolInit;
import com.mystic.atlantis.particles.ModParticleTypes;
import com.mystic.atlantis.screen.LinguisticScreen;
import com.mystic.atlantis.screen.WritingScreen;
import com.mystic.atlantis.structures.AtlantisStructures;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="atlantis")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Atlantis {
    public static final Logger LOGGER = LogManager.getLogger((String)"atlantis");

    public Atlantis() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AtlantisConfig.CONFIG_SPEC);
        ModParticleTypes.PARTICLES.register(bus);
        this.onInitialize(bus);
        AtlantisFeature.init(bus);
        AtlantisStructures.DEFERRED_REGISTRY_STRUCTURE.register(bus);
    }

    @SubscribeEvent
    public void loadCompleted(FMLLoadCompleteEvent event) {
        ModContainer createContainer = (ModContainer)ModList.get().getModContainerById("atlantis").orElseThrow(() -> new IllegalStateException("Create Mod Container missing after loadCompleted"));
        createContainer.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, previousScreen) -> (Screen)AutoConfig.getConfigScreen(AtlantisConfig.class, (Screen)previousScreen).get()));
    }

    public static ResourceLocation id(String id) {
        return new ResourceLocation("atlantis", id);
    }

    public static ResourceKey<Level> getOverworldKey() {
        ResourceLocation OVERWORLD_ID = LevelStem.f_63971_.m_135782_();
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)OVERWORLD_ID);
    }

    public void onInitialize(IEventBus bus) {
        GeckoLib.initialize();
        ItemInit.init(bus);
        BlockInit.init(bus);
        PaintingVariantsInit.init(bus);
        AtlantisModifierInit.init(bus);
        TileEntityInit.init(bus);
        FluidTypesInit.init(bus);
        FluidInit.init(bus);
        AtlantisGroupInit.init();
        AtlantisEntityInit.init(bus);
        AtlantisSoundEventInit.init(bus);
        EffectsInit.init(bus);
        EnchantmentInit.init(bus);
        MenuTypeInit.init(bus);
        RecipesInit.init(bus);
        POITypesInit.init(bus);
    }

    @SubscribeEvent
    public static void onClientSet(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeInit.LINGUISTIC.get()), LinguisticScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeInit.WRITING.get()), WritingScreen::new);
        });
    }

    @SubscribeEvent
    public static void onCommonSet(FMLCommonSetupEvent event) {
        ToolInit.init();
        TagsInit.init();
        event.enqueueWork(DimensionAtlantis::registerBiomeSources);
        ((ExtendedBlockEntity)BlockEntityType.f_58924_).addAdditionalValidBlock((Block)BlockInit.ATLANTEAN_SIGNS.get(), (Block)BlockInit.ATLANTEAN_WALL_SIGN.get());
        ((ExtendedBlockEntity)BlockEntityType.f_58924_).addAdditionalValidBlock((Block)BlockInit.PALM_SIGNS.get(), (Block)BlockInit.PALM_WALL_SIGN.get());
        SpawnPlacements.m_21754_((EntityType)((EntityType)AtlantisEntityInit.CRAB.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrabEntity::canSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)AtlantisEntityInit.COCONUT_CRAB.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CoconutCrabEntity::canSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)AtlantisEntityInit.JELLYFISH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, JellyfishEntity::canSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)AtlantisEntityInit.STARFISH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, StarfishEntity::canSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)AtlantisEntityInit.STARFISH_ZOM.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, StarfishZomEntity::canSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)AtlantisEntityInit.SHRIMP.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ShrimpEntity::canSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)AtlantisEntityInit.LEVIATHAN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LeviathanEntity::canSpawn);
        SpawnPlacements.m_21754_((EntityType)((EntityType)AtlantisEntityInit.SEAHORSE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SeahorseEntity::canSpawn);
    }
}

