/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AtlantisDimensionalEffect
extends DimensionSpecialEffects {
    public static AtlantisDimensionalEffect INSTANCE = new AtlantisDimensionalEffect();
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("atlantis:textures/environment/sun.png");
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("atlantis:textures/environment/moon_phases.png");

    private AtlantisDimensionalEffect() {
        super(255.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    public boolean renderSky(@NotNull ClientLevel world, int ticks, float tickDelta, PoseStack matrixStack, @NotNull Camera camera, @NotNull Matrix4f projectionMatrix, boolean isFoggy, @NotNull Runnable setupFog) {
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69458_((boolean)false);
        matrixStack.m_85836_();
        this.drawSun(tickDelta, matrixStack, world);
        this.drawMoonPhases(tickDelta, matrixStack, world);
        matrixStack.m_85849_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        RenderSystem.m_69482_();
        return true;
    }

    public void drawSun(float partialTicks, PoseStack matrix, ClientLevel world) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        Tesselator tessellator = Tesselator.m_85913_();
        float size = 30.0f;
        VertexFormat.Mode drawMode = VertexFormat.Mode.QUADS;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SUN_TEXTURES);
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(world.m_46942_(partialTicks) * 360.0f));
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        bufferbuilder.m_166779_(drawMode, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix4f, -size, 100.0f, -size).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrix4f, size, 100.0f, -size).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrix4f, size, 100.0f, size).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix4f, -size, 100.0f, size).m_7421_(0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
    }

    public void drawMoonPhases(float partialTicks, PoseStack matrix, ClientLevel world) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        Tesselator tessellator = Tesselator.m_85913_();
        float size = 30.0f;
        VertexFormat.Mode drawMode = VertexFormat.Mode.QUADS;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOON_PHASES_TEXTURES);
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(world.m_46942_(partialTicks) * 360.0f * 0.0015f));
        int k1 = world.m_46941_();
        int i2 = k1 % 4;
        int k2 = k1 / 4 % 2;
        float f22 = (float)(i2 + 0) / 4.0f;
        float f23 = (float)(k2 + 0) / 2.0f;
        float f24 = (float)(i2 + 1) / 4.0f;
        float f14 = (float)(k2 + 1) / 2.0f;
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        bufferbuilder.m_166779_(drawMode, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix4f, -size, -100.0f, size).m_7421_(f24, f14).m_5752_();
        bufferbuilder.m_85982_(matrix4f, size, -100.0f, size).m_7421_(f22, f14).m_5752_();
        bufferbuilder.m_85982_(matrix4f, size, -100.0f, -size).m_7421_(f22, f23).m_5752_();
        bufferbuilder.m_85982_(matrix4f, -size, -100.0f, -size).m_7421_(f24, f23).m_5752_();
        tessellator.m_85914_();
    }

    public float m_108871_() {
        return 550.0f;
    }

    @NotNull
    public Vec3 m_5927_(@NotNull Vec3 vector3d, float v) {
        return vector3d;
    }

    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
        return false;
    }

    public boolean m_5781_(int i, int i1) {
        return false;
    }
}

