/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.biomes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;

public class AtlantisBiomeSource
extends BiomeSource {
    public static final Codec<AtlantisBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(biomeSource -> BIOME_REGISTRY), (App)Codec.intRange((int)1, (int)20).fieldOf("biome_size").orElse((Object)2).forGetter(biomeSource -> biomeSource.biomeSize), (App)Codec.LONG.fieldOf("seed").stable().forGetter(biomeSource -> biomeSource.seed)).apply((Applicative)instance, instance.stable(AtlantisBiomeSource::new)));
    public static final ResourceLocation ATLANTEAN_GARDEN = new ResourceLocation("atlantis", "atlantean_garden");
    public static final ResourceLocation ATLANTIS_BIOME = new ResourceLocation("atlantis", "atlantis_biome");
    public static final ResourceLocation JELLYFISH_FIELDS = new ResourceLocation("atlantis", "jellyfish_fields");
    public static final ResourceLocation ATLANTEAN_ISLANDS = new ResourceLocation("atlantis", "atlantean_islands_biome");
    public static final ResourceLocation VOLCANIC_DARKSEA = new ResourceLocation("atlantis", "volcanic_darksea");
    public static final ResourceLocation GOO_LAGOONS = new ResourceLocation("atlantis", "goo_lagoons");
    public static final ResourceLocation COCONUT_ISLES = new ResourceLocation("atlantis", "coconut_isles");
    public static Registry<Biome> BIOME_REGISTRY;
    public Registry<Biome> LAYERS_BIOME_REGISTRY;
    private long seed;
    private int biomeSize;

    public AtlantisBiomeSource(Registry<Biome> biomeRegistry, int biomeSize, long seed) {
        super(biomeRegistry.m_7854_((Object)Objects.requireNonNull((Biome)biomeRegistry.m_7745_(biomeRegistry.m_6566_().stream().reduce((resourceLocation, resourceLocation2) -> resourceLocation).orElse(Biomes.f_48166_.m_211136_())))).stream().map(arg_0 -> biomeRegistry.m_206081_(arg_0)));
        BIOME_REGISTRY = biomeRegistry;
        this.LAYERS_BIOME_REGISTRY = biomeRegistry;
        this.biomeSize = biomeSize;
        this.seed = seed;
    }

    private static Holder<Biome> getHolderBiome(ResourceLocation resourceLocationBiome) {
        return Holder.m_205709_((Object)Objects.requireNonNull((Biome)BIOME_REGISTRY.m_7745_(resourceLocationBiome)));
    }

    @NotNull
    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    @NotNull
    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler noise) {
        if (y > 300) {
            return AtlantisBiomeSource.getHolderBiome(COCONUT_ISLES);
        }
        if ((double)((int)noise.m_183445_(x, y, z).f_187003_()) > 0.6 && (double)noise.m_183445_(x, y, z).f_187003_() < 0.7) {
            return AtlantisBiomeSource.getHolderBiome(ATLANTEAN_GARDEN);
        }
        if ((double)((int)noise.m_183445_(x, y, z).f_187003_()) > 0.5 && (double)noise.m_183445_(x, y, z).f_187003_() < 0.6) {
            return AtlantisBiomeSource.getHolderBiome(GOO_LAGOONS);
        }
        if ((double)((int)noise.m_183445_(x, y, z).f_187003_()) > 0.4 && (double)((int)noise.m_183445_(x, y, z).f_187003_()) < 0.5) {
            return AtlantisBiomeSource.getHolderBiome(VOLCANIC_DARKSEA);
        }
        if ((double)((int)noise.m_183445_(x, y, z).f_187003_()) > 0.3 && (double)noise.m_183445_(x, y, z).f_187003_() < 0.4) {
            return AtlantisBiomeSource.getHolderBiome(JELLYFISH_FIELDS);
        }
        return AtlantisBiomeSource.getHolderBiome(ATLANTIS_BIOME);
    }
}

