/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.data.BlockFamily;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public record BlockType(RegistryObject<Block> block, RegistryObject<SlabBlock> slab, RegistryObject<WallBlock> wall, RegistryObject<FenceBlock> fence, RegistryObject<FenceGateBlock> fenceGate, RegistryObject<DoorBlock> door, RegistryObject<TrapDoorBlock> trapDoor, RegistryObject<ButtonBlock> button, RegistryObject<PressurePlateBlock> pressurePlate) {
    private static final Map<BlockType, Supplier<BlockFamily>> MAP = Maps.newHashMap();

    @NotNull
    public static Stream<BlockFamily> getAllFamilies() {
        return MAP.values().stream().map(Supplier::get);
    }

    public static BlockType of(RegistryObject<Block> blockBase, RegistryObject<SlabBlock> blockSlab, RegistryObject<WallBlock> blockWall, RegistryObject<FenceBlock> blockFence, RegistryObject<FenceGateBlock> blockGateBlock, RegistryObject<DoorBlock> blockDoor, RegistryObject<TrapDoorBlock> blockTrapDoor, RegistryObject<ButtonBlock> blockButton, RegistryObject<PressurePlateBlock> pressurePlate) {
        BlockType blockType = new BlockType(blockBase, blockSlab, blockWall, blockFence, blockGateBlock, blockDoor, blockTrapDoor, blockButton, pressurePlate);
        MAP.computeIfAbsent(blockType, blockType1 -> Suppliers.memoize(() -> BlockType.family(blockType1)));
        return blockType;
    }

    public static BlockFamily family(BlockType type) {
        BlockFamily.Builder family = new BlockFamily.Builder((Block)type.block.get());
        if (type.slab != null) {
            family.m_175986_((Block)type.slab.get());
        }
        if (type.door != null) {
            family.m_175980_((Block)type.door.get());
        }
        if (type.trapDoor != null) {
            family.m_175994_((Block)type.trapDoor.get());
        }
        if (type.pressurePlate != null) {
            family.m_175990_((Block)type.pressurePlate.get());
        }
        if (type.button != null) {
            family.m_175963_((Block)type.button.get());
        }
        if (type.wall != null) {
            family.m_175996_((Block)type.wall.get());
        }
        if (type.fence != null) {
            family.m_175982_((Block)type.fence.get());
        }
        if (type.fenceGate != null) {
            family.m_175982_((Block)type.fenceGate.get());
        }
        return family.m_175962_();
    }
}

