/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.plants;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.grower.OakTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AtlanteanSaplingBlock
extends SaplingBlock
implements SimpleWaterloggedBlock {
    public static final Property<Boolean> WATERLOGGED = BlockStateProperties.f_61362_;

    public AtlanteanSaplingBlock(BlockBehaviour.Properties settings) {
        super((AbstractTreeGrower)new OakTreeGrower(), settings.m_60977_().m_60913_(0.2f, 0.4f).m_60918_(SoundType.f_56740_).m_60910_().m_60955_());
        ComposterBlock.f_51914_.put((Object)this, 0.3f);
        ((BlockState)this.m_49966_().m_61124_(WATERLOGGED, (Comparable)Boolean.TRUE)).m_61124_((Property)f_55973_, (Comparable)Integer.valueOf(0));
    }

    public boolean m_7923_(BlockState targetState) {
        return true;
    }

    protected boolean m_6266_(BlockState targetState, BlockGetter worldIn, BlockPos targetPos) {
        return !targetState.m_60812_(worldIn, targetPos).m_83263_(Direction.UP).m_83281_() || targetState.m_60783_(worldIn, targetPos, Direction.UP);
    }

    public boolean m_7898_(BlockState targetState, LevelReader world, BlockPos targetPos) {
        BlockPos below = targetPos.m_7495_();
        if (this.isWaterAt(world, targetPos)) {
            return this.m_6266_(world.m_8055_(below), (BlockGetter)world, below);
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState targetState, BlockGetter getter, BlockPos targetPos, CollisionContext context) {
        return f_55974_;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState targetState = context.m_43725_().m_8055_(context.m_8083_());
        if (targetState.m_60713_((Block)this)) {
            return targetState;
        }
        FluidState targetFluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean isWater = targetFluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_(WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    private void growTree(ServerLevel level, ChunkGenerator generator, BlockPos targetPos, BlockState targetState, RandomSource random) {
        if (level.m_5962_().m_6632_(Registry.f_122881_).isPresent()) {
            ConfiguredFeature configuredAtlanteanTreeFeature = (ConfiguredFeature)((Registry)level.m_5962_().m_6632_(Registry.f_122881_).get()).m_7745_(new ResourceLocation("atlantis", "atlantean_tree_configured"));
            BlockState legacyTargetState = level.m_6425_(targetPos).m_76188_();
            level.m_7731_(targetPos, legacyTargetState, 4);
            if (configuredAtlanteanTreeFeature != null) {
                if (configuredAtlanteanTreeFeature.m_224953_((WorldGenLevel)level, generator, random, targetPos)) {
                    if (level.m_8055_(targetPos) == legacyTargetState) {
                        level.m_7260_(targetPos, targetState, legacyTargetState, 2);
                    }
                } else {
                    level.m_7731_(targetPos, targetState, 4);
                }
            }
        }
    }

    public void m_222000_(ServerLevel level, BlockPos targetPos, BlockState targetState, RandomSource random) {
        if ((Integer)targetState.m_61143_((Property)f_55973_) == 0) {
            level.m_7731_(targetPos, (BlockState)targetState.m_61122_((Property)f_55973_), 4);
        } else {
            this.growTree(level, level.m_7726_().m_8481_(), targetPos, targetState, random);
        }
    }

    public boolean onTreeGrow(BlockState targetState, LevelReader reader, BiConsumer<BlockPos, BlockState> placeFunction, RandomSource random, BlockPos targetPos, TreeConfiguration config) {
        return true;
    }

    public FluidState m_5888_(BlockState targetState) {
        return (Boolean)targetState.m_61143_(WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(targetState);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, f_55973_});
    }

    public HolderSet<Block> getAir() {
        Holder airHolderSet = Holder.m_205709_((Object)Blocks.f_50016_);
        return HolderSet.m_205809_((Holder[])new Holder[]{airHolderSet});
    }

    public boolean isWaterAt(LevelReader reader, BlockPos targetPos) {
        return !reader.m_8055_(targetPos).m_204341_(this.getAir()) || !this.canPlaceBlockAt(reader, targetPos);
    }

    public boolean canPlaceOn(BlockState targetState) {
        return targetState.m_60734_() == Blocks.f_49994_ || targetState.m_60734_() == Blocks.f_50062_ || targetState.m_60734_() == Blocks.f_50034_ || targetState.m_60734_() == Blocks.f_50493_ || targetState.m_60734_() == Blocks.f_49992_;
    }

    public boolean canPlaceBlockAt(LevelReader reader, BlockPos targetPos) {
        BlockState targetState = reader.m_8055_(targetPos.m_7495_());
        if (reader.m_8055_(targetPos.m_7494_()).m_60713_(Blocks.f_49990_)) {
            return true;
        }
        return !this.canPlaceOn(targetState);
    }
}

