/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.power.atlanteanstone;

import com.google.common.base.MoreObjects;
import com.mystic.atlantis.blocks.power.atlanteanstone.AtlanteanPowerTorchBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class AtlanteanTripwireHook
extends TripWireHookBlock
implements SimpleWaterloggedBlock {
    private static final Property<Boolean> WATERLOGGED = AtlanteanPowerTorchBlock.WATERLOGGED;

    public AtlanteanTripwireHook(BlockBehaviour.Properties settings) {
        super(settings.m_60966_());
        this.m_49966_().m_61124_(WATERLOGGED, (Comparable)Boolean.TRUE);
    }

    public BlockState m_7417_(BlockState targetState, Direction curDir, BlockState neighborState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighborPos) {
        return curDir.m_122424_() == targetState.m_61143_((Property)f_57667_) && !targetState.m_60710_((LevelReader)accessor, targetPos) ? Blocks.f_49990_.m_49966_() : super.m_7417_(targetState, curDir, neighborState, accessor, targetPos, neighborPos);
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_57667_, f_57668_, f_57669_, WATERLOGGED});
    }

    public void m_57685_(Level level, BlockPos targetPos, BlockState hookState, boolean beingRemoved, boolean notifyNeighbours, int searchRange, @Nullable BlockState targetState) {
        BlockPos relativePos;
        Direction direction = (Direction)hookState.m_61143_((Property)TripWireHookBlock.f_57667_);
        boolean isAttached = (Boolean)hookState.m_61143_((Property)f_57669_);
        boolean isPowered = (Boolean)hookState.m_61143_((Property)f_57668_);
        boolean stillExists = !beingRemoved;
        boolean poweredAndArmed = false;
        int facingChecks = 0;
        BlockState[] targetStates = new BlockState[42];
        for (int k = 1; k < 42; ++k) {
            relativePos = targetPos.m_5484_(direction, k);
            BlockState relativeState = level.m_8055_(relativePos);
            if (relativeState.m_60713_((Block)this)) {
                if (relativeState.m_61143_((Property)TripWireHookBlock.f_57667_) != direction.m_122424_()) break;
                facingChecks = k;
                break;
            }
            if (!relativeState.m_60713_((Block)this) && k != searchRange) {
                targetStates[k] = null;
                stillExists = false;
                continue;
            }
            if (k == searchRange) {
                relativeState = (BlockState)MoreObjects.firstNonNull((Object)targetState, (Object)relativeState);
            }
            boolean isRelativeStateArmed = (Boolean)relativeState.m_61143_((Property)TripWireBlock.f_57592_) == false;
            boolean isRelativeStatePowered = (Boolean)relativeState.m_61143_((Property)TripWireBlock.f_57590_);
            poweredAndArmed |= isRelativeStateArmed && isRelativeStatePowered;
            targetStates[k] = relativeState;
            if (k != searchRange) continue;
            level.m_186460_(targetPos, (Block)this, 10);
            stillExists &= isRelativeStateArmed;
        }
        BlockState curState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_57669_, (Comparable)Boolean.valueOf(stillExists))).m_61124_((Property)f_57668_, (Comparable)Boolean.valueOf(poweredAndArmed &= (stillExists &= facingChecks > 1)));
        if (facingChecks > 0) {
            relativePos = targetPos.m_5484_(direction, facingChecks);
            Direction oppositeDir = direction.m_122424_();
            level.m_7731_(relativePos, (BlockState)curState.m_61124_((Property)TripWireHookBlock.f_57667_, (Comparable)oppositeDir), 3);
            this.m_57693_(level, relativePos, oppositeDir);
            this.playSound(level, relativePos, stillExists, poweredAndArmed, isAttached, isPowered);
        }
        this.playSound(level, targetPos, stillExists, poweredAndArmed, isAttached, isPowered);
        if (!beingRemoved) {
            level.m_7731_(targetPos, (BlockState)curState.m_61124_((Property)TripWireHookBlock.f_57667_, (Comparable)direction), 3);
            if (notifyNeighbours) {
                this.m_57693_(level, targetPos, direction);
            }
        }
        if (isAttached != stillExists) {
            for (int l = 1; l < facingChecks; ++l) {
                BlockPos relativeTargetPos = targetPos.m_5484_(direction, l);
                BlockState curTargetState = targetStates[l];
                if (curTargetState == null) continue;
                level.m_7731_(relativeTargetPos, (BlockState)curTargetState.m_61124_((Property)f_57669_, (Comparable)Boolean.valueOf(stillExists)), 3);
                if (level.m_8055_(relativeTargetPos).m_60795_()) continue;
            }
        }
    }

    private void playSound(Level level, BlockPos targetPos, boolean attached, boolean on, boolean detached, boolean off) {
        if (on && !off) {
            level.m_5594_(null, targetPos, SoundEvents.f_12524_, SoundSource.BLOCKS, 0.4f, 0.6f);
            level.m_142346_(null, GameEvent.f_223702_, targetPos);
        } else if (!on && off) {
            level.m_5594_(null, targetPos, SoundEvents.f_12523_, SoundSource.BLOCKS, 0.4f, 0.5f);
            level.m_142346_(null, GameEvent.f_223703_, targetPos);
        } else if (attached && !detached) {
            level.m_5594_(null, targetPos, SoundEvents.f_12522_, SoundSource.BLOCKS, 0.4f, 0.7f);
            level.m_142346_(null, GameEvent.f_157791_, targetPos);
        } else if (!attached && detached) {
            level.m_5594_(null, targetPos, SoundEvents.f_12525_, SoundSource.BLOCKS, 0.4f, 1.2f / (level.f_46441_.m_188501_() * 0.2f + 0.9f));
            level.m_142346_(null, GameEvent.f_157795_, targetPos);
        }
    }

    private void m_57693_(Level level, BlockPos targetPos, Direction curDir) {
        level.m_46672_(targetPos, (Block)this);
        level.m_46672_(targetPos.m_121945_(curDir.m_122424_()), (Block)this);
    }

    public FluidState m_5888_(BlockState targetState) {
        return (Boolean)targetState.m_61143_(WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(targetState);
    }

    public boolean m_7898_(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        if (reader.m_6425_(targetPos).m_205070_(FluidTags.f_13131_)) {
            Direction facingDir = (Direction)targetState.m_61143_((Property)f_57667_);
            BlockPos relativePos = targetPos.m_121945_(facingDir.m_122424_());
            BlockState relativeState = reader.m_8055_(relativePos);
            return facingDir.m_122434_().m_122479_() && relativeState.m_60783_((BlockGetter)reader, relativePos, facingDir);
        }
        return false;
    }
}

