/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.power.atlanteanstone;

import com.mystic.atlantis.blocks.power.atlanteanstone.SodiumPrimedBombBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class SodiumBombBlock
extends Block {
    public static final BooleanProperty UNSTABLE = BlockStateProperties.f_61361_;

    public SodiumBombBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)UNSTABLE, (Comparable)Boolean.valueOf(false)));
    }

    public void onCaughtFire(@NotNull BlockState targetState, @NotNull Level level, @NotNull BlockPos targetPos, @Nullable Direction facingDir, @Nullable LivingEntity igniter) {
        SodiumBombBlock.explode(level, targetPos, igniter);
    }

    public void m_6807_(BlockState targetState, @NotNull Level level, @NotNull BlockPos targetPos, BlockState oldState, boolean moving) {
        if (!oldState.m_60713_(targetState.m_60734_()) && level.m_46753_(targetPos)) {
            this.onCaughtFire(targetState, level, targetPos, null, null);
            level.m_7471_(targetPos, false);
        }
    }

    public void m_6861_(@NotNull BlockState targetState, Level level, @NotNull BlockPos targetPos, @NotNull Block targetBlock, @NotNull BlockPos fromPos, boolean moving) {
        if (level.m_46753_(targetPos)) {
            this.onCaughtFire(targetState, level, targetPos, null, null);
            level.m_7471_(targetPos, false);
        }
    }

    public void m_5707_(Level level, @NotNull BlockPos targetPos, @NotNull BlockState targetState, @NotNull Player player) {
        if (!level.m_5776_() && !player.m_7500_() && ((Boolean)targetState.m_61143_((Property)UNSTABLE)).booleanValue()) {
            this.onCaughtFire(targetState, level, targetPos, null, null);
        }
        super.m_5707_(level, targetPos, targetState, player);
    }

    public void m_7592_(Level level, BlockPos targetPos, Explosion explosion) {
        if (!level.f_46443_) {
            SodiumPrimedBombBlock primedtnt = new SodiumPrimedBombBlock(level, (double)targetPos.m_123341_() + 0.5, targetPos.m_123342_(), (double)targetPos.m_123343_() + 0.5, explosion.m_46079_());
            int fuse = primedtnt.getFuse();
            primedtnt.setFuse((short)(level.f_46441_.m_188503_(fuse / 4) + fuse / 8));
            level.m_7967_((Entity)primedtnt);
        }
    }

    @Deprecated
    public static void explode(Level level, @NotNull BlockPos targetPos) {
        SodiumBombBlock.explode(level, targetPos, null);
    }

    @Deprecated
    private static void explode(Level level, BlockPos targetPos, @Nullable LivingEntity igniter) {
        if (!level.f_46443_) {
            SodiumPrimedBombBlock primedtnt = new SodiumPrimedBombBlock(level, (double)targetPos.m_123341_() + 0.5, targetPos.m_123342_(), (double)targetPos.m_123343_() + 0.5, igniter);
            level.m_7967_((Entity)primedtnt);
            level.m_6263_(null, primedtnt.m_20185_(), primedtnt.m_20186_(), primedtnt.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_((Entity)igniter, GameEvent.f_157776_, targetPos);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState targetState, @NotNull Level level, @NotNull BlockPos targetPos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!heldStack.m_150930_(Items.f_42409_) && !heldStack.m_150930_(Items.f_42613_)) {
            return super.m_6227_(targetState, level, targetPos, player, hand, result);
        }
        this.onCaughtFire(targetState, level, targetPos, result.m_82434_(), (LivingEntity)player);
        BlockState airState = Blocks.f_50016_.m_49966_();
        BlockState waterOrAirState = level.m_8055_(targetPos.m_7495_()) == airState || level.m_8055_(targetPos.m_7494_()) == airState || level.m_8055_(targetPos.m_122012_()) == airState || level.m_8055_(targetPos.m_122024_()) == airState || level.m_8055_(targetPos.m_122029_()) == airState || level.m_8055_(targetPos.m_122019_()) == airState ? airState : Blocks.f_49990_.m_49966_();
        level.m_7731_(targetPos, waterOrAirState, 11);
        Item heldItem = heldStack.m_41720_();
        if (!player.m_7500_()) {
            if (heldStack.m_150930_(Items.f_42409_)) {
                heldStack.m_41622_(1, (LivingEntity)player, arg2 -> arg2.m_21190_(hand));
            } else {
                heldStack.m_41774_(1);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)heldItem));
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_5581_(Level level, @NotNull BlockState targetState, @NotNull BlockHitResult result, @NotNull Projectile projectile) {
        if (!level.f_46443_) {
            BlockPos targetPos = result.m_82425_();
            Entity projectileOwner = projectile.m_37282_();
            if (projectile.m_6060_() && projectile.m_142265_(level, targetPos)) {
                this.onCaughtFire(targetState, level, targetPos, null, projectileOwner instanceof LivingEntity ? (LivingEntity)projectileOwner : null);
                level.m_7471_(targetPos, false);
            }
        }
    }

    public boolean m_6903_(@NotNull Explosion explosion) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UNSTABLE});
    }
}

