/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.blocks.power.atlanteanstone;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mystic.atlantis.blocks.power.atlanteanstone.AtlanteanPowerTorchBlock;
import com.mystic.atlantis.init.BlockInit;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WallAtlanteanPowerTorchBlock
extends AtlanteanPowerTorchBlock {
    private static final Property<Direction> FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Property<Boolean> WATERLOGGED = AtlanteanPowerTorchBlock.WATERLOGGED;
    private static final Map<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));

    public WallAtlanteanPowerTorchBlock(BlockBehaviour.Properties settings) {
        super(settings.lootFrom(() -> (Block)BlockInit.ATLANTEAN_POWER_TORCH.get()).m_60910_().m_60966_().m_60953_(level -> 7).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)f_55674_, (Comparable)Boolean.valueOf(true))).m_61124_(WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public BlockState m_7417_(BlockState targetState, Direction curDir, BlockState neighborState, LevelAccessor accessor, BlockPos targetPos, BlockPos neighborPos) {
        return curDir.m_122424_() == targetState.m_61143_(FACING) && !this.m_7898_(targetState, (LevelReader)accessor, targetPos) ? Blocks.f_49990_.m_49966_() : targetState;
    }

    @Override
    public boolean m_7898_(BlockState targetState, LevelReader reader, BlockPos targetPos) {
        if (reader.m_6425_(targetPos).m_205070_(FluidTags.f_13131_)) {
            return Blocks.f_50082_.m_7898_(targetState, reader, targetPos);
        }
        return false;
    }

    protected boolean m_6918_(Level level, BlockPos targetPos, BlockState targetState) {
        Direction facingDir = ((Direction)targetState.m_61143_(FACING)).m_122424_();
        return level.m_46616_(targetPos.m_121945_(facingDir), facingDir);
    }

    public int m_6378_(BlockState targetState, BlockGetter getter, BlockPos targetPos, Direction curDir) {
        return (Boolean)targetState.m_61143_((Property)f_55674_) != false && targetState.m_61143_(FACING) != curDir ? 15 : 0;
    }

    public BlockState m_6843_(BlockState targetState, Rotation currentRot) {
        return (BlockState)targetState.m_61124_(FACING, (Comparable)currentRot.m_55954_((Direction)targetState.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_(FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return WallAtlanteanPowerTorchBlock.getBoundingShape(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction[] directions;
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        Direction[] var6 = directions = ctx.m_6232_();
        int var7 = directions.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            Direction direction = var6[var8];
            if (!direction.m_122434_().m_122479_()) continue;
            Direction direction2 = direction.m_122424_();
            blockState = (BlockState)((BlockState)blockState.m_61124_(FACING, (Comparable)direction2)).m_61124_(WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (worldView.m_6425_(blockPos).m_205070_(FluidTags.f_13131_) && this.m_7898_(blockState, (LevelReader)worldView, blockPos)) {
                return blockState;
            }
            return blockState;
        }
        return null;
    }

    public static VoxelShape getBoundingShape(BlockState state) {
        return BOUNDING_SHAPES.get(state.m_61143_(FACING));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, f_55674_, WATERLOGGED});
    }
}

