/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.dimension;

import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.dimension.AtlanteanPortalForcer;
import com.mystic.atlantis.dimension.DimensionAtlantis;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public interface AtlanteanITeleporter
extends ITeleporter {
    @Nullable
    default public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return this.getExitPortal(destWorld, player.m_20183_(), false, DimensionAtlantis.isAtlantisDimension((Level)destWorld), destWorld.m_6857_(), player).map(p_258249_ -> {
                Vec3 vec3;
                Direction.Axis direction$axis;
                BlockState blockstate = destWorld.m_8055_(player.m_20183_());
                if (blockstate.m_61138_((Property)BlockStateProperties.f_61364_)) {
                    direction$axis = (Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_);
                    BlockUtil.FoundRectangle blockutil$foundrectangle = BlockUtil.m_124334_((BlockPos)player.m_20183_(), (Direction.Axis)direction$axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_284700_ -> destWorld.m_8055_(p_284700_) == blockstate);
                    vec3 = this.getRelativePortalPosition(direction$axis, blockutil$foundrectangle, (Entity)player);
                } else {
                    direction$axis = Direction.Axis.X;
                    vec3 = new Vec3(0.5, 0.0, 0.0);
                }
                return PortalShape.m_77699_((ServerLevel)destWorld, (BlockUtil.FoundRectangle)p_258249_, (Direction.Axis)direction$axis, (Vec3)vec3, (EntityDimensions)EntityDimensions.m_20398_((float)player.m_20205_(), (float)player.m_20206_()), (Vec3)player.m_20184_(), (float)player.m_146908_(), (float)player.m_146909_());
            }).orElse(null);
        }
        return this.getExitPortal(destWorld, entity.m_20183_(), DimensionAtlantis.isAtlantisDimension((Level)destWorld), destWorld.m_6857_(), entity).map(p_258249_ -> {
            Vec3 vec3;
            Direction.Axis direction$axis;
            BlockState blockstate = destWorld.m_8055_(entity.m_20183_());
            if (blockstate.m_61138_((Property)BlockStateProperties.f_61364_)) {
                direction$axis = (Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_);
                BlockUtil.FoundRectangle blockutil$foundrectangle = BlockUtil.m_124334_((BlockPos)entity.m_20183_(), (Direction.Axis)direction$axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_284700_ -> destWorld.m_8055_(p_284700_) == blockstate);
                vec3 = this.getRelativePortalPosition(direction$axis, blockutil$foundrectangle, entity);
            } else {
                direction$axis = Direction.Axis.X;
                vec3 = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.m_77699_((ServerLevel)destWorld, (BlockUtil.FoundRectangle)p_258249_, (Direction.Axis)direction$axis, (Vec3)vec3, (EntityDimensions)EntityDimensions.m_20398_((float)entity.m_20205_(), (float)entity.m_20206_()), (Vec3)entity.m_20184_(), (float)entity.m_146908_(), (float)entity.m_146909_());
        }).orElse(null);
    }

    default public Optional<BlockUtil.FoundRectangle> getExitPortal(ServerLevel pDestination, BlockPos pFindFrom, boolean doesNothing, boolean pIsToAtlantis, WorldBorder pWorldBorder, ServerPlayer serverPlayer) {
        Optional<BlockUtil.FoundRectangle> optional = this.getExitPortal(pDestination, pFindFrom, pIsToAtlantis, pWorldBorder, (Entity)serverPlayer);
        if (optional.isPresent()) {
            if (serverPlayer.f_19839_ == 0) {
                serverPlayer.f_19839_ = 300;
                return optional;
            }
        } else {
            Direction.Axis direction$axis = serverPlayer.f_19853_.m_8055_(serverPlayer.m_20183_()).m_61145_((Property)BlockStateProperties.f_61365_).orElse(Direction.Axis.Y);
            AtlanteanPortalForcer atlanteanPortalForcer = new AtlanteanPortalForcer(pDestination);
            if (serverPlayer.f_19839_ == 0) {
                serverPlayer.f_19839_ = 300;
                Optional<BlockUtil.FoundRectangle> optional1 = atlanteanPortalForcer.createPortal(pFindFrom, direction$axis);
                if (optional1.isEmpty()) {
                    Atlantis.LOGGER.error("Unable to create a portal, likely target out of worldborder");
                }
                return optional1;
            }
        }
        return Optional.empty();
    }

    default public Optional<BlockUtil.FoundRectangle> getExitPortal(ServerLevel pDestination, BlockPos pFindFrom, boolean pIsToAtlantis, WorldBorder pWorldBorder, Entity entity) {
        AtlanteanPortalForcer atlanteanPortalForcer = new AtlanteanPortalForcer(pDestination);
        return atlanteanPortalForcer.findPortalAround(pFindFrom, pIsToAtlantis, pWorldBorder);
    }

    default public Vec3 getRelativePortalPosition(Direction.Axis pAxis, BlockUtil.FoundRectangle pPortal, Entity entity) {
        return PortalShape.m_77738_((BlockUtil.FoundRectangle)pPortal, (Direction.Axis)pAxis, (Vec3)entity.m_20182_(), (EntityDimensions)entity.m_6972_(entity.m_20089_()));
    }
}

