/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.init.ItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class JellyfishEntity
extends WaterAnimal
implements IAnimatable,
Bucketable {
    protected static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(JellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(JellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(JellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final AnimationBuilder HOVER_ANIMATION = new AnimationBuilder().addAnimation("animation.jellyfish.hover", Boolean.valueOf(true));
    private static final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("animation.jellyfish.idle", Boolean.valueOf(true));
    private int randomTimer;
    private float tx;
    private float ty;
    private float tz;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public JellyfishEntity(EntityType<? extends WaterAnimal> entityType, Level world) {
        super(entityType, world);
        this.randomTimer = this.m_217043_().m_188503_(61);
        this.m_20242_(false);
    }

    public boolean canSwimInFluidType(FluidType type) {
        return this.isInFluidType(Blocks.f_49990_.m_49966_().m_60819_().getFluidType());
    }

    public static AttributeSupplier.Builder createJellyfishAttributes() {
        return JellyfishEntity.m_21552_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    public static boolean canSpawn(EntityType<JellyfishEntity> jellyfishEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() >= 75 && 105 >= pos.m_123342_() && serverWorldAccess.m_8055_(pos).m_60713_(Blocks.f_49990_);
    }

    public boolean m_6067_() {
        return true;
    }

    protected boolean m_6129_() {
        return true;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() == ItemInit.CRAB_LEGS.get()) {
            if (player instanceof ServerPlayer) {
                this.m_146852_(GameEvent.f_223708_, (Entity)this);
                this.createChild((ServerLevel)player.m_20193_(), this);
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(hand).m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(hand).m_41720_() == Items.f_42447_) {
            return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
        }
        if (player.m_21120_(hand).m_41720_() == Items.f_42787_) {
            ItemStack itemStack = player.m_21120_(hand);
            if (!player.m_150110_().f_35937_) {
                player.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
                ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)((Item)ItemInit.JELLY_BOTTLE.get()).m_7968_());
                player.m_21008_(hand, itemStack2);
            } else {
                player.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
                ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)((Item)ItemInit.JELLY_BOTTLE.get()).m_7968_());
                player.m_21008_(hand, itemStack2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new JellyFishRandomMovementGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.CRAB_LEGS.get()}), false));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.f_19804_.m_135381_(VARIANT, (Object)(this.f_19796_.m_188503_(100) > 50 ? 1 : 2));
        this.f_19804_.m_135381_(COLOR, (Object)this.f_19796_.m_188503_(15));
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void m_20258_(CompoundTag nbt) {
        this.m_27497_(nbt.m_128471_("FromBucket"));
        this.f_19804_.m_135381_(VARIANT, (Object)nbt.m_128451_("Variant"));
        this.setColor(nbt.m_128451_("Color"));
        super.m_20258_(nbt);
    }

    public CompoundTag m_20240_(CompoundTag nbt) {
        nbt.m_128379_("FromBucket", this.m_27487_());
        nbt.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
        nbt.m_128405_("Color", this.getColor());
        return super.m_20240_(nbt);
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public ItemStack m_28282_() {
        return ((Item)ItemInit.JELLYFISH_BUCKET.get()).m_7968_();
    }

    public void m_142278_(CompoundTag nbt) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)nbt);
    }

    public void m_6872_(ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(COLOR, (Object)this.f_19796_.m_188503_(15));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && --this.randomTimer <= 0) {
            this.randomTimer = this.m_217043_().m_188503_(21);
            this.m_20334_((double)this.tx * 1.2, (double)this.ty * 1.6, (double)this.tz * 1.2);
        }
        this.m_6710_((LivingEntity)this.f_19853_.m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0, true));
    }

    public void createChild(ServerLevel world, JellyfishEntity entity) {
        JellyfishEntity child = (JellyfishEntity)this.m_6095_().m_20615_((Level)world);
        if (child != null) {
            child.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            world.m_7967_((Entity)child);
        }
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double distanceSquared) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6573_(@NotNull Player player) {
        return true;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean isMovingSlowly() {
        return this.m_20184_().m_7096_() != 0.0 && this.m_20184_().m_7098_() != 0.0 && this.m_20184_().m_7094_() != 0.0;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.isMovingSlowly()) {
            event.getController().setAnimation(HOVER_ANIMATION);
        } else {
            event.getController().setAnimation(IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public void setMovementVector(float randomMotionVecX, float randomMotionVecY, float randomMotionVecZ) {
        this.tx = randomMotionVecX;
        this.ty = randomMotionVecY;
        this.tz = randomMotionVecZ;
    }

    public boolean hasMovementVector() {
        return this.tx != 0.0f || this.ty != 0.0f || this.tz != 0.0f;
    }

    static class JellyFishRandomMovementGoal
    extends Goal {
        private final JellyfishEntity jellyfishEntity;

        public JellyFishRandomMovementGoal(JellyfishEntity arg2) {
            this.jellyfishEntity = arg2;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            int i = this.jellyfishEntity.m_21216_();
            if (i > 100) {
                this.jellyfishEntity.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.jellyfishEntity.m_217043_().m_188503_(JellyFishRandomMovementGoal.m_186073_((int)50)) == 0 || !this.jellyfishEntity.f_19798_ || !this.jellyfishEntity.hasMovementVector()) {
                float f = this.jellyfishEntity.m_217043_().m_188501_() * ((float)Math.PI * 2);
                float g = Mth.m_14089_((float)f) * 0.2f;
                float h = -0.1f + this.jellyfishEntity.m_217043_().m_188501_() * 0.2f;
                float j = Mth.m_14031_((float)f) * 0.2f;
                this.jellyfishEntity.setMovementVector(g, h, j);
            }
        }
    }
}

