/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.entities.JellyfishEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class LeviathanEntity
extends WaterAnimal
implements IAnimatable {
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)24.166098f);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(LeviathanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Vec3 moveTargetPoint;
    private BlockPos anchorPoint;
    private AttackPhase attackPhase;
    private static final AnimationBuilder SWIM_IDLE_ANIMATION = new AnimationBuilder().addAnimation("animation.leviathan.swim", Boolean.valueOf(true));
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public static AttributeSupplier.Builder createLeviathanAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 2.0);
    }

    public LeviathanEntity(EntityType<? extends WaterAnimal> arg, Level arg2) {
        super(arg, arg2);
        this.moveTargetPoint = Vec3.f_82478_;
        this.anchorPoint = BlockPos.f_121853_;
        this.attackPhase = AttackPhase.CIRCLE;
        this.f_21364_ = 5;
        this.f_21342_ = new LeviathanEntityMoveControl((Mob)this);
        this.f_21365_ = new LeviathanEntityLookControl((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LeviathanEntityAttackStrategyGoal());
        this.f_21345_.m_25352_(2, (Goal)new LeviathanEntitySweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new LeviathanEntityCircleAroundAnchorGoal());
        this.f_21346_.m_25352_(0, (Goal)new LeviathanEntityAttackJellyfishGoal());
        this.f_21346_.m_25352_(1, (Goal)new LeviathanEntityAttackPlayerTargetGoal());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            float f = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            float f1 = Mth.m_14089_((float)((float)(this.getUniqueFlapTickOffset() + this.f_19797_ + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12230_, this.m_5720_(), 0.95f + this.f_19796_.m_188501_() * 0.05f, 0.95f + this.f_19796_.m_188501_() * 0.05f, false);
            }
            int i = this.getLeviathanEntitySize();
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
        }
    }

    public void setLeviathanEntitySize(int pSize) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)Mth.m_14045_((int)pSize, (int)0, (int)64));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)0);
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.anchorPoint = this.m_20183_().m_6630_(5);
        this.setLeviathanEntitySize(0);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("AX")) {
            this.anchorPoint = new BlockPos(pCompound.m_128451_("AX"), pCompound.m_128451_("AY"), pCompound.m_128451_("AZ"));
        }
        this.setLeviathanEntitySize(pCompound.m_128451_("Size"));
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("AX", this.anchorPoint.m_123341_());
        pCompound.m_128405_("AY", this.anchorPoint.m_123342_());
        pCompound.m_128405_("AZ", this.anchorPoint.m_123343_());
        pCompound.m_128405_("Size", this.getLeviathanEntitySize());
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12227_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12231_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public boolean m_6549_(@NotNull EntityType<?> pType) {
        return true;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        int i = this.getLeviathanEntitySize();
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        float f = (entitydimensions.f_20377_ + 0.2f * (float)i) / entitydimensions.f_20377_;
        return entitydimensions.m_20388_(f);
    }

    public int getLeviathanEntitySize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    protected float m_6431_(@NotNull Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.35f;
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> pKey) {
        if (ID_SIZE.equals(pKey)) {
            this.updateLeviathanEntitySizeInfo();
        }
        super.m_7350_(pKey);
    }

    private void updateLeviathanEntitySizeInfo() {
        this.m_6210_();
        Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_((double)(6 + this.getLeviathanEntitySize()));
    }

    public int getUniqueFlapTickOffset() {
        return this.m_19879_() * 3;
    }

    public boolean m_142039_() {
        return (this.getUniqueFlapTickOffset() + this.f_19797_) % TICKS_PER_FLAP == 0;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new LeviathanEntityBodyRotationControl((Mob)this);
    }

    protected boolean m_8028_() {
        return true;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(SWIM_IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static boolean canSpawn(EntityType<LeviathanEntity> leviathanEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() >= 75 && 105 >= pos.m_123342_() && serverWorldAccess.m_8055_(pos).m_60713_(Blocks.f_49990_);
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class LeviathanEntityMoveControl
    extends MoveControl {
        private float speed;

        public LeviathanEntityMoveControl(Mob p_33241_) {
            super(p_33241_);
            this.speed = 0.1f;
        }

        public void m_8126_() {
            if (LeviathanEntity.this.f_19862_) {
                LeviathanEntity.this.m_146922_(LeviathanEntity.this.m_146908_() + 180.0f);
                this.speed = 0.1f;
            }
            float f = (float)(LeviathanEntity.this.moveTargetPoint.f_82479_ - LeviathanEntity.this.m_20185_());
            float g = (float)(LeviathanEntity.this.moveTargetPoint.f_82480_ - LeviathanEntity.this.m_20186_());
            float h = (float)(LeviathanEntity.this.moveTargetPoint.f_82481_ - LeviathanEntity.this.m_20189_());
            double d = Mth.m_14116_((float)(f * f + h * h));
            if (Math.abs(d) > (double)1.0E-5f) {
                double e = 1.0 - (double)Mth.m_14154_((float)(g * 0.7f)) / d;
                f = (float)((double)f * e);
                h = (float)((double)h * e);
                d = Mth.m_14116_((float)(f * f + h * h));
                double i = Mth.m_14116_((float)(f * f + h * h + g * g));
                float j = LeviathanEntity.this.m_146908_();
                float k = (float)Mth.m_14136_((double)h, (double)f);
                float l = Mth.m_14177_((float)(LeviathanEntity.this.m_146908_() + 90.0f));
                float m = Mth.m_14177_((float)(k * 57.295776f));
                LeviathanEntity.this.m_146922_(Mth.m_14148_((float)l, (float)m, (float)4.0f) - 90.0f);
                LeviathanEntity.this.f_20883_ = LeviathanEntity.this.m_146908_();
                this.speed = Mth.m_14145_((float)j, (float)LeviathanEntity.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.2f, (float)0.025f);
                float n = (float)(-(Mth.m_14136_((double)(-g), (double)d) * 57.2957763671875));
                LeviathanEntity.this.m_146926_(n);
                float o = LeviathanEntity.this.m_146908_() + 90.0f;
                double p = (double)(this.speed * Mth.m_14089_((float)(o * ((float)Math.PI / 180)))) * Math.abs((double)f / i);
                double q = (double)(this.speed * Mth.m_14031_((float)(o * ((float)Math.PI / 180)))) * Math.abs((double)h / i);
                double r = (double)(this.speed * Mth.m_14031_((float)(n * ((float)Math.PI / 180)))) * Math.abs((double)g / i);
                Vec3 vec3 = LeviathanEntity.this.m_20184_();
                LeviathanEntity.this.m_20256_(vec3.m_82549_(new Vec3(p, r, q).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    static class LeviathanEntityLookControl
    extends LookControl {
        public LeviathanEntityLookControl(Mob p_33235_) {
            super(p_33235_);
        }

        public void m_8128_() {
        }
    }

    class LeviathanEntityAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        LeviathanEntityAttackStrategyGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = LeviathanEntity.this.m_5448_();
            return livingentity != null && LeviathanEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_);
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            LeviathanEntity.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            LeviathanEntity.this.anchorPoint = LeviathanEntity.this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, LeviathanEntity.this.anchorPoint).m_6630_(10 + LeviathanEntity.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (LeviathanEntity.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    LeviathanEntity.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.m_183277_((8 + LeviathanEntity.this.f_19796_.m_188503_(4)) * 20);
                    LeviathanEntity.this.m_5496_(SoundEvents.f_12232_, 10.0f, 0.95f + LeviathanEntity.this.f_19796_.m_188501_() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            if (LeviathanEntity.this.m_5448_() != null) {
                LeviathanEntity.this.anchorPoint = LeviathanEntity.this.m_5448_().m_20183_().m_6630_(20 + LeviathanEntity.this.f_19796_.m_188503_(20));
                if (LeviathanEntity.this.anchorPoint.m_123342_() < LeviathanEntity.this.f_19853_.m_5736_()) {
                    LeviathanEntity.this.anchorPoint = new BlockPos(LeviathanEntity.this.anchorPoint.m_123341_(), LeviathanEntity.this.f_19853_.m_5736_() + 1, LeviathanEntity.this.anchorPoint.m_123343_());
                }
            }
        }
    }

    class LeviathanEntitySweepAttackGoal
    extends LeviathanEntityMoveTargetGoal {
        LeviathanEntitySweepAttackGoal() {
        }

        public boolean m_8036_() {
            return LeviathanEntity.this.m_5448_() != null && LeviathanEntity.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = LeviathanEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.m_5833_() || player.m_7500_()) {
                    return false;
                }
            }
            return this.m_8036_();
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            LeviathanEntity.this.m_6710_(null);
            LeviathanEntity.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            LivingEntity livingentity = LeviathanEntity.this.m_5448_();
            if (livingentity != null) {
                LeviathanEntity.this.moveTargetPoint = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
                if (LeviathanEntity.this.m_20191_().m_82400_((double)0.2f).m_82381_(livingentity.m_20191_())) {
                    LeviathanEntity.this.m_7327_((Entity)livingentity);
                    LeviathanEntity.this.attackPhase = AttackPhase.CIRCLE;
                    if (!LeviathanEntity.this.m_20067_()) {
                        LeviathanEntity.this.f_19853_.m_46796_(1039, LeviathanEntity.this.m_20183_(), 0);
                    }
                } else if (LeviathanEntity.this.f_19862_ || LeviathanEntity.this.f_20916_ > 0) {
                    LeviathanEntity.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class LeviathanEntityCircleAroundAnchorGoal
    extends LeviathanEntityMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        LeviathanEntityCircleAroundAnchorGoal() {
        }

        public boolean m_8036_() {
            return LeviathanEntity.this.m_5448_() == null || LeviathanEntity.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void m_8056_() {
            this.distance = 5.0f + LeviathanEntity.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + LeviathanEntity.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = LeviathanEntity.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (LeviathanEntity.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + LeviathanEntity.this.f_19796_.m_188501_() * 9.0f;
            }
            if (LeviathanEntity.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (LeviathanEntity.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = LeviathanEntity.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (LeviathanEntity.this.moveTargetPoint.f_82480_ < LeviathanEntity.this.m_20186_() && !LeviathanEntity.this.f_19853_.m_46859_(LeviathanEntity.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (LeviathanEntity.this.moveTargetPoint.f_82480_ > LeviathanEntity.this.m_20186_() && !LeviathanEntity.this.f_19853_.m_46859_(LeviathanEntity.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)LeviathanEntity.this.anchorPoint)) {
                LeviathanEntity.this.anchorPoint = LeviathanEntity.this.m_20183_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            LeviathanEntity.this.moveTargetPoint = Vec3.m_82528_((Vec3i)LeviathanEntity.this.anchorPoint).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    class LeviathanEntityAttackJellyfishGoal
    extends Goal {
        private int nextScanTick = LeviathanEntityAttackJellyfishGoal.m_186073_((int)20);

        LeviathanEntityAttackJellyfishGoal() {
        }

        public boolean m_8036_() {
            if (LeviathanEntity.this.m_5448_() != null) {
                return false;
            }
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
            } else {
                this.nextScanTick = LeviathanEntityAttackJellyfishGoal.m_186073_((int)60);
                List list = LeviathanEntity.this.f_19853_.m_45976_(JellyfishEntity.class, LeviathanEntity.this.m_20191_().m_82377_(16.0, 64.0, 16.0));
                if (!list.isEmpty()) {
                    list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                    for (JellyfishEntity jellyFish : list) {
                        if (!LeviathanEntity.this.m_21040_((LivingEntity)jellyFish, TargetingConditions.f_26872_)) continue;
                        LeviathanEntity.this.m_6710_((LivingEntity)jellyFish);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = LeviathanEntity.this.m_5448_();
            return livingentity != null && LeviathanEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_);
        }

        public void m_8056_() {
            super.m_8056_();
            LeviathanEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 0x7FFFFFFE));
        }

        public void m_8041_() {
            super.m_8041_();
            LeviathanEntity.this.m_21195_(MobEffects.f_19609_);
        }
    }

    class LeviathanEntityAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = LeviathanEntityAttackPlayerTargetGoal.m_186073_((int)20);

        LeviathanEntityAttackPlayerTargetGoal() {
        }

        public boolean m_8036_() {
            if (LeviathanEntity.this.m_5448_() != null) {
                return false;
            }
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
            } else {
                this.nextScanTick = LeviathanEntityAttackPlayerTargetGoal.m_186073_((int)60);
                List list = LeviathanEntity.this.f_19853_.m_45955_(this.attackTargeting, (LivingEntity)LeviathanEntity.this, LeviathanEntity.this.m_20191_().m_82377_(16.0, 64.0, 16.0));
                if (!list.isEmpty()) {
                    list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                    for (Player player : list) {
                        if (!LeviathanEntity.this.m_21040_((LivingEntity)player, TargetingConditions.f_26872_) || !(LeviathanEntity.this.m_21188_() instanceof Player)) continue;
                        LeviathanEntity.this.m_6710_((LivingEntity)player);
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = LeviathanEntity.this.m_5448_();
            return livingentity != null && LeviathanEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_);
        }

        public void m_8056_() {
            super.m_8056_();
            LeviathanEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 0x7FFFFFFE));
        }

        public void m_8041_() {
            super.m_8041_();
            LeviathanEntity.this.m_21195_(MobEffects.f_19609_);
        }
    }

    class LeviathanEntityBodyRotationControl
    extends BodyRotationControl {
        public LeviathanEntityBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void m_8121_() {
            LeviathanEntity.this.f_20885_ = LeviathanEntity.this.f_20883_;
            LeviathanEntity.this.f_20883_ = LeviathanEntity.this.m_146908_();
        }
    }

    abstract class LeviathanEntityMoveTargetGoal
    extends Goal {
        public LeviathanEntityMoveTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return LeviathanEntity.this.moveTargetPoint.m_82531_(LeviathanEntity.this.m_20185_(), LeviathanEntity.this.m_20186_(), LeviathanEntity.this.m_20189_()) < 4.0;
        }
    }
}

