/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import com.mystic.atlantis.init.ItemInit;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SeahorseEntity
extends WaterAnimal
implements IAnimatable,
Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(SeahorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(SeahorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final AnimationBuilder CORAL_IDLE_ANIMATION = new AnimationBuilder().addAnimation("animation.seahorse.coral-idle", Boolean.valueOf(true));
    private static final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("animation.seahorse.idle", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_ANIMATION = new AnimationBuilder().addAnimation("animation.seahorse.swim", Boolean.valueOf(true));
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final List<Block> CORALS = List.of(Blocks.f_50596_, Blocks.f_50586_, Blocks.f_50554_, Blocks.f_50564_, Blocks.f_50595_, Blocks.f_50585_, Blocks.f_50553_, Blocks.f_50563_, Blocks.f_50597_, Blocks.f_50587_, Blocks.f_50555_, Blocks.f_50565_, Blocks.f_50598_, Blocks.f_50588_, Blocks.f_50556_, Blocks.f_50566_, Blocks.f_50594_, Blocks.f_50584_, Blocks.f_50552_, Blocks.f_50562_);
    private final List<BlockPos> HORIZONAL_DIRECTIONS = List.of(this.m_20183_().m_122012_(), this.m_20183_().m_122019_(), this.m_20183_().m_122024_(), this.m_20183_().m_122029_());

    public SeahorseEntity(EntityType<? extends WaterAnimal> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createSeahorseAttributes() {
        return SeahorseEntity.m_21552_().m_22268_(Attributes.f_22279_, 2.5);
    }

    public static boolean canSpawn(EntityType<SeahorseEntity> seahorseEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() >= 75 && 95 >= pos.m_123342_() && serverWorldAccess.m_8055_(pos).m_60713_(Blocks.f_49990_);
    }

    public float m_6134_() {
        return 0.7f;
    }

    public boolean m_6040_() {
        return true;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.f_19804_.m_135381_(COLOR, (Object)SeahorseEntity.betterNiceColor());
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void m_20258_(CompoundTag nbt) {
        this.setColor(nbt.m_128451_("Color"));
        this.m_27497_(nbt.m_128471_("FromBucket"));
        super.m_20258_(nbt);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_142278_(CompoundTag nbt) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)nbt);
    }

    public void m_6872_(ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public CompoundTag m_20240_(CompoundTag nbt) {
        nbt.m_128405_("Color", this.getColor());
        nbt.m_128379_("FromBucket", this.m_27487_());
        return super.m_20240_(nbt);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(COLOR, (Object)SeahorseEntity.betterNiceColor());
    }

    public void createChild(ServerLevel world, SeahorseEntity entity) {
        SeahorseEntity child = (SeahorseEntity)this.m_6095_().m_20615_((Level)world);
        if (child != null) {
            child.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            world.m_7967_((Entity)child);
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.6875f;
    }

    public boolean m_6067_() {
        return super.m_6067_();
    }

    protected boolean m_6129_() {
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() == Items.f_41867_) {
            if (player instanceof ServerPlayer) {
                this.m_146852_(GameEvent.f_223708_, (Entity)this);
                this.createChild((ServerLevel)player.m_20193_(), this);
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(hand).m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(hand).m_41720_() == Items.f_42447_) {
            return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
        }
        return InteractionResult.FAIL;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.5, 1));
        this.f_21345_.m_25352_(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41867_}), false));
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12529_;
    }

    public ItemStack m_28282_() {
        return ((Item)ItemInit.SEAHORSE_BUCKET.get()).m_7968_();
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public static int betterNiceColor() {
        return ThreadLocalRandom.current().nextInt(0x1000000);
    }

    public boolean isMovingSlowly() {
        return this.m_20184_().m_7096_() != 0.0 && this.m_20184_().m_7098_() != 0.0 && this.m_20184_().m_7094_() != 0.0;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.isMovingSlowly()) {
            event.getController().setAnimation(SWIM_ANIMATION);
        } else {
            for (BlockPos pos : this.HORIZONAL_DIRECTIONS) {
                for (Block block : this.CORALS) {
                    if (this.f_19853_.m_8055_(this.m_20183_().m_121955_((Vec3i)pos)).equals(block.m_49966_())) {
                        event.getController().setAnimation(IDLE_ANIMATION);
                        continue;
                    }
                    event.getController().setAnimation(IDLE_ANIMATION);
                }
            }
        }
        return PlayState.CONTINUE;
    }
}

