/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class StarfishZomEntity
extends Monster
implements IAnimatable {
    private static final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("animation.starfish.walk", Boolean.valueOf(true));
    private static final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("animation.starfish.idle", Boolean.valueOf(true));
    private static final AnimationBuilder EAT_ANIMATION = new AnimationBuilder().addAnimation("animation.starfish.eat", Boolean.valueOf(true));
    private static final AnimationBuilder JUMP_ANIMATION = new AnimationBuilder().addAnimation("animation.starfish.jump", Boolean.valueOf(true));
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public StarfishZomEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6040_() {
        return true;
    }

    public static AttributeSupplier.Builder createStarfishAttributes() {
        return StarfishZomEntity.m_21552_().m_22268_(Attributes.f_22279_, 1.2);
    }

    public void registerControllers(AnimationData controllerRegistrar) {
        controllerRegistrar.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected boolean m_7341_(Entity entity) {
        return !entity.m_20160_() && !entity.m_20363_((Entity)this);
    }

    public void m_6083_() {
        Player player;
        Entity entity = this.m_20202_();
        if (entity instanceof Player && (player = (Player)entity).m_6144_()) {
            this.m_8127_();
        }
        if (!(entity.m_6084_() || entity instanceof Drowned || entity instanceof Player || this.m_7341_(entity))) {
            this.m_8127_();
        } else {
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_8119_();
            if (entity instanceof Drowned) {
                Drowned drowned = (Drowned)entity;
                this.m_6034_(drowned.m_20185_(), Math.max(drowned.m_20186_() + (double)(drowned.m_20192_() * 0.25f), drowned.m_20186_()), drowned.m_20189_());
                drowned.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 1, 5));
                if (drowned.m_21223_() > 1.0f) {
                    drowned.m_6469_(DamageSource.m_19370_((LivingEntity)this), 1.0f);
                }
                if (!drowned.m_6084_()) {
                    this.m_6038_();
                }
            } else if (entity instanceof Player) {
                Player player2 = (Player)entity;
                this.m_6034_(player2.m_20185_(), Math.max(player2.m_20186_() + (double)player2.m_20192_(), player2.m_20186_()), player2.m_20189_());
                player2.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 1, 5));
                player2.m_6469_(DamageSource.m_19370_((LivingEntity)this), 1.0f);
                if (!player2.m_6084_() || player2.m_7500_()) {
                    this.m_6038_();
                }
            }
        }
    }

    public static boolean canSpawn(EntityType<StarfishZomEntity> starfishZomEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() >= 75 && 95 >= pos.m_123342_() && serverWorldAccess.m_8055_(pos).m_60713_(Blocks.f_49990_);
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 10.0f));
        this.f_21345_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{StarfishZomEntity.class}));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_6710_((LivingEntity)this.f_19853_.m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0, true));
    }

    public boolean isMovingSlowly() {
        return this.m_20184_().m_7096_() != 0.0 && this.m_20184_().m_7098_() != 0.0 && this.m_20184_().m_7094_() != 0.0;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.m_20159_()) {
            event.getController().setAnimation(EAT_ANIMATION);
        } else if (this.isMovingSlowly()) {
            event.getController().setAnimation(WALK_ANIMATION);
        } else if (this.m_6069_()) {
            event.getController().setAnimation(JUMP_ANIMATION);
        } else {
            event.getController().setAnimation(IDLE_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

