/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mystic.atlantis.entities.SeahorseEntity;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;

public class SeahorseEntityRenderer
extends GeoEntityRenderer<SeahorseEntity> {
    public SeahorseEntityRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<SeahorseEntity> modelProvider) {
        super(renderManager, modelProvider);
    }

    public void render(@NotNull SeahorseEntity mobEntity, float f, float g, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, int i) {
        if (mobEntity.m_20145_()) {
            matrixStack.m_85836_();
            matrixStack.m_85849_();
        } else {
            this.renderStuff(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
        }
        Entity entity = mobEntity.m_21524_();
        if (entity != null) {
            this.method_4073(mobEntity, g, matrixStack, vertexConsumerProvider, entity);
        }
    }

    private void renderStuff(SeahorseEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        Direction direction;
        Entity entity2;
        stack.m_85836_();
        boolean shouldSit = entity.m_20159_() && entity.m_20202_() != null;
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = entity.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)entity.f_20886_, (float)entity.f_20885_);
        float netHeadYaw = f1 - f;
        if (shouldSit && (entity2 = entity.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            netHeadYaw = f1 - f;
            float f3 = Mth.m_14177_((float)netHeadYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            netHeadYaw = f1 - f;
        }
        float headPitch = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        if (entity.m_20089_() == Pose.SLEEPING && (direction = entity.m_21259_()) != null) {
            float f4 = entity.m_20236_(Pose.STANDING) - 0.1f;
            stack.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
        }
        float f7 = this.getLerpedAge((LivingEntity)entity, partialTicks);
        this.applyRotations((LivingEntity)entity, stack, f7, f, partialTicks);
        float lastLimbDistance = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && entity.m_6084_()) {
            lastLimbDistance = Mth.m_14179_((float)partialTicks, (float)entity.f_20923_, (float)entity.f_20924_);
            limbSwing = entity.f_20925_ - entity.f_20924_ * (1.0f - partialTicks);
            if (entity.m_6162_()) {
                limbSwing *= 3.0f;
            }
            if (lastLimbDistance > 1.0f) {
                lastLimbDistance = 1.0f;
            }
        }
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -netHeadYaw;
        AnimationEvent predicate = new AnimationEvent((IAnimatable)entity, limbSwing, lastLimbDistance, partialTicks, !(lastLimbDistance > -0.15f) || !(lastLimbDistance < 0.15f), Collections.singletonList(entityModelData));
        GeoModel model = this.getGeoModelProvider().getModel(this.getGeoModelProvider().getModelResource((Object)entity));
        GeoModelProvider geoModelProvider = this.getGeoModelProvider();
        if (geoModelProvider instanceof IAnimatableModel) {
            IAnimatableModel model1 = (IAnimatableModel)geoModelProvider;
            model1.setCustomAnimations((Object)entity, this.getInstanceId((LivingEntity)entity), predicate);
        }
        stack.m_85837_(0.0, (double)0.01f, 0.0);
        Minecraft.m_91087_().m_91097_().m_174784_(this.getTextureLocation((LivingEntity)entity));
        int renderColor = entity.getColor();
        RenderType renderType = this.getRenderType((Object)entity, partialTicks, stack, bufferIn, null, packedLightIn, this.getTextureLocation((LivingEntity)entity));
        boolean invis = Minecraft.m_91087_().f_91074_ != null && entity.m_20177_((Player)Minecraft.m_91087_().f_91074_);
        this.render(model, (Object)entity, partialTicks, renderType, stack, bufferIn, null, packedLightIn, this.getOverlay((LivingEntity)entity, 0.0f), (float)(renderColor >> 16 & 0xFF) / 255.0f, (float)(renderColor >> 8 & 0xFF) / 255.0f, (float)(renderColor & 0xFF) / 255.0f, invis ? 0.0f : 0.49019608f);
        if (!entity.m_5833_()) {
            for (GeoLayerRenderer layerRenderer : this.layerRenderers) {
                layerRenderer.render(stack, bufferIn, packedLightIn, (Entity)entity, limbSwing, lastLimbDistance, partialTicks, f7, netHeadYaw, headPitch);
            }
        }
        stack.m_85849_();
        if (this.shouldShowName((LivingEntity)entity)) {
            this.m_7649_((Entity)entity, entity.m_5446_(), stack, bufferIn, packedLightIn);
        }
    }

    private <E extends Entity> void method_4073(SeahorseEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource provider, E holdingEntity) {
        int v;
        matrices.m_85836_();
        Vec3 vec3d = holdingEntity.m_20252_(tickDelta);
        double d = (double)(Mth.m_14179_((float)tickDelta, (float)entity.f_20883_, (float)entity.f_20884_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec3d2 = entity.m_7939_();
        double e = Math.cos(d) * vec3d2.f_82481_ + Math.sin(d) * vec3d2.f_82479_;
        double f = Math.sin(d) * vec3d2.f_82481_ - Math.cos(d) * vec3d2.f_82479_;
        double g = Mth.m_14139_((double)tickDelta, (double)entity.f_19854_, (double)entity.m_20185_()) + e;
        double h = Mth.m_14139_((double)tickDelta, (double)entity.f_19855_, (double)entity.m_20186_()) + vec3d2.f_82480_;
        double i = Mth.m_14139_((double)tickDelta, (double)entity.f_19856_, (double)entity.m_20189_()) + f;
        matrices.m_85837_(e, vec3d2.f_82480_, f);
        float j = (float)(vec3d.f_82479_ - g);
        float k = (float)(vec3d.f_82480_ - h);
        float l = (float)(vec3d.f_82481_ - i);
        float m = 0.025f;
        VertexConsumer vertexConsumer = provider.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = matrices.m_85850_().m_85861_();
        float n = Mth.m_14195_((float)(j * j + l * l)) * 0.025f / 2.0f;
        float o = l * n;
        float p = j * n;
        BlockPos blockPos = new BlockPos(entity.m_20299_(tickDelta));
        BlockPos blockPos2 = new BlockPos(holdingEntity.m_20299_(tickDelta));
        int q = this.m_6086_((Entity)entity, blockPos);
        int r = this.f_114476_.m_114382_(holdingEntity).m_6086_(holdingEntity, blockPos2);
        int s = entity.f_19853_.m_45517_(LightLayer.SKY, blockPos);
        int t = entity.f_19853_.m_45517_(LightLayer.SKY, blockPos2);
        for (v = 0; v <= 24; ++v) {
            SeahorseEntityRenderer.method_23187(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.025f, o, p, v, false);
        }
        for (v = 24; v >= 0; --v) {
            SeahorseEntityRenderer.method_23187(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.0f, o, p, v, true);
        }
        matrices.m_85849_();
    }

    public static void method_23187(VertexConsumer vertexConsumer, Matrix4f matrix4f, float f, float g, float h, int i, int j, int k, int l, float m, float n, float o, float p, int q, boolean bl) {
        float r = (float)q / 24.0f;
        int s = (int)Mth.m_14179_((float)r, (float)i, (float)j);
        int t = (int)Mth.m_14179_((float)r, (float)k, (float)l);
        int u = LightTexture.m_109885_((int)s, (int)t);
        float v = q % 2 == (bl ? 1 : 0) ? 0.7f : 1.0f;
        float w = 0.5f * v;
        float x = 0.4f * v;
        float y = 0.3f * v;
        float z = f * r;
        float aa = g > 0.0f ? g * r * r : g - g * (1.0f - r) * (1.0f - r);
        float ab = h * r;
        vertexConsumer.m_85982_(matrix4f, z - o, aa + n, ab + p).m_85950_(w, x, y, 1.0f).m_85969_(u).m_5752_();
        vertexConsumer.m_85982_(matrix4f, z + o, aa + m - n, ab - p).m_85950_(w, x, y, 1.0f).m_85969_(u).m_5752_();
    }
}

