/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.entities.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.mystic.atlantis.entities.SubmarineEntity;
import com.mystic.atlantis.entities.models.SubmarineEntityModel;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class SubmarineEntityRenderer
extends EntityRenderer<SubmarineEntity>
implements IGeoRenderer<SubmarineEntity> {
    private final AnimatedGeoModel<SubmarineEntity> modelProvider;
    protected MultiBufferSource rtb = Minecraft.m_91087_().m_91269_().m_110104_();

    public SubmarineEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.modelProvider = new SubmarineEntityModel();
    }

    public void render(SubmarineEntity entityIn, float entity, float yaw, PoseStack tickDelta, MultiBufferSource matrices, int vertexConsumers) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelResource((Object)entityIn));
        tickDelta.m_85836_();
        tickDelta.m_85845_(Vector3f.f_122225_.m_122240_(-Mth.m_14179_((float)yaw, (float)entityIn.f_19859_, (float)entityIn.m_146908_())));
        tickDelta.m_85837_(0.0, -0.5, 0.0);
        tickDelta.m_85841_(3.0f, 3.0f, 3.0f);
        Minecraft.m_91087_().m_91097_().m_174784_(this.getTextureLocation(entityIn));
        Color renderColor = this.getRenderColor((Object)entityIn, yaw, tickDelta, matrices, null, vertexConsumers);
        RenderType renderType = this.getRenderType((Object)entityIn, yaw, tickDelta, matrices, null, vertexConsumers, this.getTextureLocation(entityIn));
        this.render(model, (Object)entityIn, yaw, renderType, tickDelta, matrices, null, vertexConsumers, SubmarineEntityRenderer.getPackedOverlay((Entity)entityIn, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        float lastLimbDistance = 0.0f;
        float limbSwing = 0.0f;
        EntityModelData entityModelData = new EntityModelData();
        AnimationEvent predicate = new AnimationEvent((IAnimatable)entityIn, limbSwing, lastLimbDistance, yaw, !(lastLimbDistance > -0.15f) || !(lastLimbDistance < 0.15f), Collections.singletonList(entityModelData));
        this.modelProvider.setCustomAnimations((Object)entityIn, this.getInstanceId((Object)entityIn), predicate);
        tickDelta.m_85849_();
        super.m_7392_((Entity)entityIn, entity, yaw, tickDelta, matrices, vertexConsumers);
    }

    public static int getPackedOverlay(Entity livingEntityIn, float uIn) {
        return OverlayTexture.m_118090_((float)OverlayTexture.m_118088_((float)uIn), (boolean)false);
    }

    public void setCurrentRTB(MultiBufferSource bufferSource) {
        this.rtb = bufferSource;
    }

    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    public GeoModelProvider<SubmarineEntity> getGeoModelProvider() {
        return this.modelProvider;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull SubmarineEntity instance) {
        return this.modelProvider.getTextureResource((Object)instance);
    }
}

