/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.feature;

import com.mojang.serialization.Codec;
import com.mystic.atlantis.blocks.base.SeaBedBlock;
import com.mystic.atlantis.config.AtlantisConfig;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.util.FastNoiseLite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class AtlanteanIslands
extends Feature<NoneFeatureConfiguration> {
    FastNoiseLite perlin = null;

    public AtlanteanIslands(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        this.setSeed(context.m_159774_().m_7328_());
        double radius = 15.0;
        BlockPos pos = context.m_159777_();
        SectionPos chunkPos = SectionPos.m_123199_((BlockPos)pos);
        if (context.m_159774_().m_141928_() < 60) {
            return false;
        }
        if ((chunkPos.m_123341_() & 1) == 1 || (chunkPos.m_123342_() & 1) == context.m_225041_().m_188503_(2) || (chunkPos.m_123343_() & 1) == 1) {
            return false;
        }
        if (((Boolean)AtlantisConfig.INSTANCE.islandsOn.get()).booleanValue()) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (double x = -radius; x <= radius; x += 1.0) {
                for (double y = 1.0; y <= radius; y += 1.0) {
                    for (double z = -radius; z <= radius; z += 1.0) {
                        mutable.m_122190_((Vec3i)context.m_159777_()).m_122184_((int)x, (int)(y - radius), (int)z);
                        double noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_()));
                        double scaledNoise = noise * (y * 3.0 / (x * x + z * z));
                        if (!(scaledNoise >= 0.5)) continue;
                        if (y == radius) {
                            context.m_159774_().m_7731_((BlockPos)mutable, ((SeaBedBlock)((Object)BlockInit.SEABED.get())).m_49966_(), 2);
                            continue;
                        }
                        context.m_159774_().m_7731_((BlockPos)mutable, Blocks.f_50062_.m_49966_(), 2);
                    }
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

