/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.mojang.math.Vector3f;
import com.mystic.atlantis.fluids.BaseFluidType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FluidTypesInit {
    public static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
    public static final ResourceLocation WATER_FLOWING = new ResourceLocation("block/water_flow");
    public static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_overlay");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"atlantis");
    public static final RegistryObject<FluidType> JETSTREAM_WATER_FLUID_TYPE = FluidTypesInit.registerJetstreamWaterType("jetstream_water", FluidType.Properties.create().lightLevel(0).density(15).viscosity(1000).sound(SoundAction.get((String)"drink"), SoundEvents.f_11911_));
    public static final RegistryObject<FluidType> SALTY_SEA_WATER_FLUID_TYPE = FluidTypesInit.registerSaltySeaWaterFluidType("salty_sea_water", FluidType.Properties.create().lightLevel(0).density(0).viscosity(1000).sound(SoundAction.get((String)"drink"), SoundEvents.f_11911_));

    private static RegistryObject<FluidType> registerJetstreamWaterType(String name, FluidType.Properties properties) {
        return FLUID_TYPES.register(name, () -> new BaseFluidType(WATER_STILL, WATER_FLOWING, WATER_OVERLAY, FastColor.ARGB32.m_13660_((int)255, (int)169, (int)255, (int)208), new Vector3f(0.6627451f, 1.0f, 0.8156863f), properties));
    }

    private static RegistryObject<FluidType> registerSaltySeaWaterFluidType(String name, FluidType.Properties properties) {
        return FLUID_TYPES.register(name, () -> new BaseFluidType(WATER_STILL, WATER_FLOWING, WATER_OVERLAY, FastColor.ARGB32.m_13660_((int)255, (int)10, (int)96, (int)208), new Vector3f(0.039215688f, 0.3764706f, 0.8156863f), properties));
    }

    private static RegistryObject<FluidType> registerMilkType(String name, FluidType fluidType) {
        return FLUID_TYPES.register(name, () -> fluidType);
    }

    public static void init(IEventBus eventBus) {
        FLUID_TYPES.register(eventBus);
    }
}

