/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.init;

import com.mystic.atlantis.blocks.base.LinguisticGlyph;
import com.mystic.atlantis.init.AtlantisEntityInit;
import com.mystic.atlantis.init.AtlantisGroupInit;
import com.mystic.atlantis.init.AtlantisSoundEventInit;
import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.FluidInit;
import com.mystic.atlantis.init.ToolInit;
import com.mystic.atlantis.items.AtlanteanBoatItem;
import com.mystic.atlantis.items.AtlanteanCrystal;
import com.mystic.atlantis.items.AtlanteanEntityBucketItem;
import com.mystic.atlantis.items.CrabEntityBucketItem;
import com.mystic.atlantis.items.CrabLegsItem;
import com.mystic.atlantis.items.DefaultItem;
import com.mystic.atlantis.items.FireMelonJellyBottle;
import com.mystic.atlantis.items.JellyfishJellyBottle;
import com.mystic.atlantis.items.LinguisticGlyphScrollItem;
import com.mystic.atlantis.items.OrbOfAtlantis;
import com.mystic.atlantis.items.PalmBoatItem;
import com.mystic.atlantis.items.SodiumItem;
import com.mystic.atlantis.items.SubmarineItem;
import com.mystic.atlantis.items.WaterPill;
import com.mystic.atlantis.items.armor.BasicArmorMaterial;
import com.mystic.atlantis.items.armor.ItemArmorAtlantis;
import com.mystic.atlantis.items.armor.ItemArmorOrichalcum;
import com.mystic.atlantis.items.armor.ItemArmorWrought;
import com.mystic.atlantis.items.musicdisc.AtlantisMusicDisc;
import com.mystic.atlantis.items.tools.AquamarineAxe;
import com.mystic.atlantis.items.tools.AquamarineHoe;
import com.mystic.atlantis.items.tools.AquamarinePickaxe;
import com.mystic.atlantis.items.tools.AquamarineShovel;
import com.mystic.atlantis.items.tools.AquamarineSword;
import com.mystic.atlantis.items.tools.AtlanteanAmuletItem;
import com.mystic.atlantis.items.tools.AtlanteanSpearItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemInit {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"atlantis");
    private static final Map<LinguisticGlyph, RegistryObject<Item>> scrolls = new HashMap<LinguisticGlyph, RegistryObject<Item>>();
    private static final Item.Properties ATLANTIS_SETTINGS = new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41487_(1).m_41497_(Rarity.UNCOMMON).m_41487_(1);
    public static final RegistryObject<Item> ATLANTEAN_AMULET = ItemInit.register("atlantean_amulet", AtlanteanAmuletItem::new);
    public static final RegistryObject<Item> ATLANTEAN_SPEAR = ItemInit.register("atlantean_spear", () -> new AtlanteanSpearItem(ToolInit.AQUAMARINE, 5));
    public static final RegistryObject<Item> ATLANTEAN_BOAT = ItemInit.register("atlantean_boat", () -> new AtlanteanBoatItem(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41487_(1)));
    public static final RegistryObject<Item> PALM_BOAT = ItemInit.register("palm_boat", () -> new PalmBoatItem(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41487_(1)));
    public static final RegistryObject<Item> ATLANTEAN_CRAB_EGG = ItemInit.register("atlantean_crab_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.CRAB, 0x800002, 16715589, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> ATLANTEAN_JELLYFISH_EGG = ItemInit.register("atlantean_jellyfish_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.JELLYFISH, 17802, 361215, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> ATLANTEAN_SHRIMP_EGG = ItemInit.register("atlantean_shrimp_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.SHRIMP, 0xFF0000, 0xFF8000, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> LEVIATHAN_EGG = ItemInit.register("leviathan_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.LEVIATHAN, 0x1DDDDD, 11394779, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> ATLANTEAN_SEAHORSE_EGG = ItemInit.register("atlantean_seahorse_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.SEAHORSE, 16182078, 13617243, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> COCONUT_CRAB_EGG = ItemInit.register("coconut_crab_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.COCONUT_CRAB, 0x800002, 16715589, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> STARFISH_EGG = ItemInit.register("atlantean_starfish_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.STARFISH, 16753693, 16179807, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> STARFISH_ZOM_EGG = ItemInit.register("atlantean_starzomfish_egg", () -> new ForgeSpawnEggItem(AtlantisEntityInit.STARFISH_ZOM, 16646390, 41328, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> PANBEE = ItemInit.register("panbee", () -> new AtlantisMusicDisc(15, (Supplier<SoundEvent>)AtlantisSoundEventInit.PANBEE, ATLANTIS_SETTINGS, 10));
    public static final RegistryObject<Item> COLUMN_CAVITATION = ItemInit.register("column_cavitation", () -> new AtlantisMusicDisc(15, (Supplier<SoundEvent>)AtlantisSoundEventInit.COLUMN, ATLANTIS_SETTINGS, 10));
    public static final RegistryObject<Item> BROKEN_SHELLS = ItemInit.register("broken_shells", DefaultItem::new);
    public static final RegistryObject<Item> SODIUM_NUGGET = ItemInit.register("sodium_nugget", () -> new SodiumItem(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> SEA_SALT = ItemInit.register("sea_salt", DefaultItem::new);
    public static final RegistryObject<Item> FIRE_MELON_JELLY_BOTTLE = ItemInit.register("fire_melon_jelly_bottle", () -> new FireMelonJellyBottle(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> JELLY_BOTTLE = ItemInit.register("jellyfish_jelly_bottle", () -> new JellyfishJellyBottle(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> AQUAMARINE_GEM = ItemInit.register("aquamarine_gem", DefaultItem::new);
    public static final RegistryObject<Item> ORICHALCUM_INGOT = ItemInit.register("orichalcum_ingot", DefaultItem::new);
    public static final RegistryObject<Item> ORICHALCUM_BLEND = ItemInit.register("orichalcum_blend", DefaultItem::new);
    public static final RegistryObject<Item> ORB_OF_ATLANTIS = ItemInit.register("orb_of_atlantis", OrbOfAtlantis::new);
    public static final RegistryObject<Item> ATLANTEAN_CRYSTAL = ItemInit.register("atlantean_crystal", AtlanteanCrystal::new);
    public static final RegistryObject<Item> OCEAN_STONE = ItemInit.register("ocean_stone", DefaultItem::new);
    public static final RegistryObject<Item> DROP_OF_ATLANTIS = ItemInit.register("drop_of_atlantis", DefaultItem::new);
    public static final RegistryObject<Item> BROWN_WROUGHT_PATCHES = ItemInit.register("brown_wrought_patches", DefaultItem::new);
    public static final RegistryObject<Item> CRAB_LEGS = ItemInit.register("crab_legs", () -> new CrabLegsItem(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> SHRIMP = ItemInit.register("shrimp", () -> new Item(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41489_(new FoodProperties.Builder().m_38757_().m_38760_(5).m_38758_(0.2f).effect(() -> new MobEffectInstance(MobEffects.f_19604_, 100), 0.05f).m_38767_())));
    public static final RegistryObject<Item> COOKED_SHRIMP = ItemInit.register("cooked_shrimp", () -> new Item(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41489_(new FoodProperties.Builder().m_38757_().m_38760_(2).m_38758_(0.4f).m_38767_())));
    public static final RegistryObject<Item> ATLANTEAN_POWER_TORCH = ItemInit.register("atlantean_power_torch", () -> new StandingAndWallBlockItem((Block)BlockInit.ATLANTEAN_POWER_TORCH.get(), (Block)BlockInit.WALL_ATLANTEAN_POWER_TORCH.get(), new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> ATLANTEAN_POWER_DUST = ItemInit.register("atlantean_power_dust", () -> new ItemNameBlockItem((Block)BlockInit.ATLANTEAN_POWER_DUST_WIRE.get(), new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> ATLANTEAN_STRING = ItemInit.register("atlantean_string", () -> new ItemNameBlockItem((Block)BlockInit.ATLANTEAN_TRIPWIRE.get(), new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> SUBMARINE = ItemInit.register("submarine", () -> new SubmarineItem(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> WATER_PILL = ItemInit.register("water_pill", WaterPill::new);
    public static final RegistryObject<Item> ATLANTEAN_SIGN = ItemInit.register("atlantean_sign", () -> new SignItem(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN), (Block)BlockInit.ATLANTEAN_SIGNS.get(), (Block)BlockInit.ATLANTEAN_WALL_SIGN.get()));
    public static final RegistryObject<Item> PALM_SIGN = ItemInit.register("palm_sign", () -> new SignItem(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN), (Block)BlockInit.PALM_SIGNS.get(), (Block)BlockInit.PALM_WALL_SIGN.get()));
    public static final RegistryObject<Item> ATLANTEAN_FIRE_MELON_FRUIT = ItemInit.register("atlantean_fire_melon_fruit", () -> new Item(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(1.0f).m_38767_())));
    public static final RegistryObject<Item> ATLANTEAN_FIRE_MELON_FRUIT_SPIKED = ItemInit.register("atlantean_fire_melon_fruit_spiked", () -> new Item(new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41489_(new FoodProperties.Builder().m_38760_(1).m_38758_(1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19602_, 60), 1.0f).m_38767_())));
    public static final RegistryObject<Item> ATLANTEAN_FIRE_MELON_SEEDS = ItemInit.register("atlantean_fire_melon_fruit_seeds", () -> new ItemNameBlockItem((Block)BlockInit.ATLANTEAN_FIRE_MELON_TOP.get(), new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> ATLANTEAN_FIRE_MELON_SPIKE = ItemInit.register("atlantean_fire_melon_spike", DefaultItem::new);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL = ItemInit.registerGlyph(LinguisticGlyph.BLANK);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_A = ItemInit.registerGlyph(LinguisticGlyph.A);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_B = ItemInit.registerGlyph(LinguisticGlyph.B);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_C = ItemInit.registerGlyph(LinguisticGlyph.C);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_D = ItemInit.registerGlyph(LinguisticGlyph.D);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_E = ItemInit.registerGlyph(LinguisticGlyph.E);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_F = ItemInit.registerGlyph(LinguisticGlyph.F);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_G = ItemInit.registerGlyph(LinguisticGlyph.G);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_H = ItemInit.registerGlyph(LinguisticGlyph.H);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_I = ItemInit.registerGlyph(LinguisticGlyph.I);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_J = ItemInit.registerGlyph(LinguisticGlyph.J);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_K = ItemInit.registerGlyph(LinguisticGlyph.K);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_L = ItemInit.registerGlyph(LinguisticGlyph.L);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_M = ItemInit.registerGlyph(LinguisticGlyph.M);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_N = ItemInit.registerGlyph(LinguisticGlyph.N);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_O = ItemInit.registerGlyph(LinguisticGlyph.O);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_P = ItemInit.registerGlyph(LinguisticGlyph.P);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_Q = ItemInit.registerGlyph(LinguisticGlyph.Q);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_R = ItemInit.registerGlyph(LinguisticGlyph.R);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_S = ItemInit.registerGlyph(LinguisticGlyph.S);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_T = ItemInit.registerGlyph(LinguisticGlyph.T);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_U = ItemInit.registerGlyph(LinguisticGlyph.U);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_V = ItemInit.registerGlyph(LinguisticGlyph.V);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_W = ItemInit.registerGlyph(LinguisticGlyph.W);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_X = ItemInit.registerGlyph(LinguisticGlyph.X);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_Y = ItemInit.registerGlyph(LinguisticGlyph.Y);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_Z = ItemInit.registerGlyph(LinguisticGlyph.Z);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_0 = ItemInit.registerGlyph(LinguisticGlyph.ZERO);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_1 = ItemInit.registerGlyph(LinguisticGlyph.ONE);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_2 = ItemInit.registerGlyph(LinguisticGlyph.TWO);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_3 = ItemInit.registerGlyph(LinguisticGlyph.THREE);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_4 = ItemInit.registerGlyph(LinguisticGlyph.FOUR);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_5 = ItemInit.registerGlyph(LinguisticGlyph.FIVE);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_6 = ItemInit.registerGlyph(LinguisticGlyph.SIX);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_7 = ItemInit.registerGlyph(LinguisticGlyph.SEVEN);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_8 = ItemInit.registerGlyph(LinguisticGlyph.EIGHT);
    public static final RegistryObject<Item> LINGUISTIC_GLYPH_SCROLL_9 = ItemInit.registerGlyph(LinguisticGlyph.NINE);
    public static final RegistryObject<Item> JETSTREAM_WATER_BUCKET = ITEMS.register("jetstream_water_bucket", () -> new BucketItem(FluidInit.JETSTREAM_WATER, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistryObject<Item> SALTY_SEA_WATER_BUCKET = ITEMS.register("salty_sea_water_bucket", () -> new BucketItem(FluidInit.SALTY_SEA_WATER, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistryObject<Item> CRAB_BUCKET = ItemInit.register("crab_bucket", () -> new CrabEntityBucketItem((Supplier<? extends EntityType<?>>)AtlantisEntityInit.CRAB, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41487_(1)));
    public static final RegistryObject<Item> JELLYFISH_BUCKET = ItemInit.register("jellyfish_bucket", () -> new AtlanteanEntityBucketItem((Supplier<? extends EntityType<?>>)AtlantisEntityInit.JELLYFISH, (Supplier<? extends Fluid>)((Supplier<Fluid>)() -> Fluids.f_76193_), (Supplier<? extends SoundEvent>)((Supplier<SoundEvent>)() -> SoundEvents.f_11779_), new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41487_(1)));
    public static final RegistryObject<Item> SHRIMP_BUCKET = ItemInit.register("shrimp_bucket", () -> new AtlanteanEntityBucketItem((Supplier<? extends EntityType<?>>)AtlantisEntityInit.SHRIMP, (Supplier<? extends Fluid>)((Supplier<Fluid>)() -> Fluids.f_76193_), (Supplier<? extends SoundEvent>)((Supplier<SoundEvent>)() -> SoundEvents.f_11779_), new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41487_(1)));
    public static final RegistryObject<Item> SEAHORSE_BUCKET = ItemInit.register("seahorse_bucket", () -> new AtlanteanEntityBucketItem((Supplier<? extends EntityType<?>>)AtlantisEntityInit.SEAHORSE, (Supplier<? extends Fluid>)((Supplier<Fluid>)() -> Fluids.f_76193_), (Supplier<? extends SoundEvent>)((Supplier<SoundEvent>)() -> SoundEvents.f_11779_), new Item.Properties().m_41491_(AtlantisGroupInit.MAIN).m_41487_(1)));
    public static final RegistryObject<Item> AXE_AQUAMARINE = ItemInit.register("axe_aquamarine", () -> new AquamarineAxe(ToolInit.AQUAMARINE, 3.0f));
    public static final RegistryObject<Item> PICKAXE_AQUAMARINE = ItemInit.register("pickaxe_aquamarine", () -> new AquamarinePickaxe(ToolInit.AQUAMARINE, 2));
    public static final RegistryObject<Item> SHOVEL_AQUAMARINE = ItemInit.register("shovel_aquamarine", () -> new AquamarineShovel(ToolInit.AQUAMARINE, 1));
    public static final RegistryObject<Item> HOE_AQUAMARINE = ItemInit.register("hoe_aquamarine", () -> new AquamarineHoe(ToolInit.AQUAMARINE, 2));
    public static final RegistryObject<Item> SWORD_AQUAMARINE = ItemInit.register("sword_aquamarine", () -> new AquamarineSword(ToolInit.AQUAMARINE, 4));
    public static final RegistryObject<Item> ORICHALCUM_AXE = ItemInit.register("orichalcum_axe", () -> new AquamarineAxe(ToolInit.ORICHAClUM, 3.0f));
    public static final RegistryObject<Item> ORICHALCUM_PICKAXE = ItemInit.register("orichalcum_pickaxe", () -> new AquamarinePickaxe(ToolInit.ORICHAClUM, 2));
    public static final RegistryObject<Item> ORICHALCUM_SHOVEL = ItemInit.register("orichalcum_shovel", () -> new AquamarineShovel(ToolInit.ORICHAClUM, 1));
    public static final RegistryObject<Item> ORICHALCUM_HOE = ItemInit.register("orichalcum_hoe", () -> new AquamarineHoe(ToolInit.ORICHAClUM, 2));
    public static final RegistryObject<Item> ORICHALCUM_SWORD = ItemInit.register("orichalcum_sword", () -> new AquamarineSword(ToolInit.ORICHAClUM, 4));
    public static final RegistryObject<Item> AQUAMARINE_HELMET = ItemInit.register("aquamarine_helmet", () -> new ItemArmorAtlantis(BasicArmorMaterial.ARMOR_AQUAMARINE, EquipmentSlot.HEAD, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> AQUAMARINE_CHESTPLATE = ItemInit.register("aquamarine_chestplate", () -> new ItemArmorAtlantis(BasicArmorMaterial.ARMOR_AQUAMARINE, EquipmentSlot.CHEST, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> AQUAMARINE_LEGGINGS = ItemInit.register("aquamarine_leggings", () -> new ItemArmorAtlantis(BasicArmorMaterial.ARMOR_AQUAMARINE, EquipmentSlot.LEGS, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> AQUAMARINE_BOOTS = ItemInit.register("aquamarine_boots", () -> new ItemArmorAtlantis(BasicArmorMaterial.ARMOR_AQUAMARINE, EquipmentSlot.FEET, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> BROWN_WROUGHT_HELMET = ItemInit.register("brown_wrought_helmet", () -> new ItemArmorWrought(BasicArmorMaterial.ARMOR_BROWN_WROUGHT, EquipmentSlot.HEAD, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> BROWN_WROUGHT_CHESTPLATE = ItemInit.register("brown_wrought_chestplate", () -> new ItemArmorWrought(BasicArmorMaterial.ARMOR_BROWN_WROUGHT, EquipmentSlot.CHEST, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> BROWN_WROUGHT_LEGGINGS = ItemInit.register("brown_wrought_leggings", () -> new ItemArmorWrought(BasicArmorMaterial.ARMOR_BROWN_WROUGHT, EquipmentSlot.LEGS, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> BROWN_WROUGHT_BOOTS = ItemInit.register("brown_wrought_boots", () -> new ItemArmorWrought(BasicArmorMaterial.ARMOR_BROWN_WROUGHT, EquipmentSlot.FEET, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> ORICHALCUM_HELMET = ItemInit.register("orichalcum_helmet", () -> new ItemArmorOrichalcum(BasicArmorMaterial.ARMOR_ORICHALCUM, EquipmentSlot.HEAD, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> ORICHALCUM_CHESTPLATE = ItemInit.register("orichalcum_chestplate", () -> new ItemArmorOrichalcum(BasicArmorMaterial.ARMOR_ORICHALCUM, EquipmentSlot.CHEST, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> ORICHALCUM_LEGGINGS = ItemInit.register("orichalcum_leggings", () -> new ItemArmorOrichalcum(BasicArmorMaterial.ARMOR_ORICHALCUM, EquipmentSlot.LEGS, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));
    public static final RegistryObject<Item> ORICHALCUM_BOOTS = ItemInit.register("orichalcum_boots", () -> new ItemArmorOrichalcum(BasicArmorMaterial.ARMOR_ORICHALCUM, EquipmentSlot.FEET, new Item.Properties().m_41491_(AtlantisGroupInit.MAIN)));

    public static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    public static <T extends Item> RegistryObject<T> registerToGlyph(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    static RegistryObject<Item> registerGlyph(LinguisticGlyph symbol) {
        RegistryObject<Item> registryObject = ItemInit.registerToGlyph("linguistic_glyph_scroll" + symbol.toString(), () -> new LinguisticGlyphScrollItem(symbol));
        scrolls.put(symbol, registryObject);
        return registryObject;
    }

    public static RegistryObject<Item> getScroll(LinguisticGlyph a) {
        return scrolls.get((Object)a);
    }

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
    }
}

