/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.inventory;

import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.init.MenuTypeInit;
import com.mystic.atlantis.init.RecipesInit;
import com.mystic.atlantis.recipes.WritingRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class WritingMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<WritingRecipe> recipes = new ArrayList<WritingRecipe>();
    private ItemStack input = ItemStack.f_41583_;
    long lastSoundTime;
    final Slot inputSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            WritingMenu.this.m_6199_((Container)this);
            WritingMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public WritingMenu(int id, Inventory inventory) {
        this(id, inventory, ContainerLevelAccess.f_39287_);
    }

    public WritingMenu(int id, Inventory inventory, final ContainerLevelAccess accessLevel) {
        super((MenuType)MenuTypeInit.WRITING.get(), id);
        int j;
        this.access = accessLevel;
        this.level = inventory.f_35978_.f_19853_;
        this.inputSlot = this.m_38897_(new Slot(this.container, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.f_19853_, player, stack.m_41613_());
                WritingMenu.this.resultContainer.m_8015_(player);
                ItemStack itemStack = WritingMenu.this.inputSlot.m_6201_(1);
                if (!itemStack.m_41619_()) {
                    WritingMenu.this.setupResultSlot();
                }
                accessLevel.m_39292_((arg, arg2) -> {
                    long l = arg.m_46467_();
                    if (WritingMenu.this.lastSoundTime != l) {
                        arg.m_5594_(null, arg2, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        WritingMenu.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(player, stack);
            }
        });
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)inventory, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<WritingRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player player) {
        return WritingMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockInit.WRITING_BLOCK.get()));
    }

    public boolean m_6366_(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.m_6422_(id);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int i) {
        return i >= 0 && i < this.recipes.size();
    }

    public void m_6199_(Container inventory) {
        ItemStack itemStack = this.inputSlot.m_7993_();
        if (!itemStack.m_150930_(this.input.m_41720_())) {
            this.input = itemStack.m_41777_();
            this.setupRecipeList(inventory, itemStack);
        }
    }

    private void setupRecipeList(Container inventory, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_(RecipesInit.Types.WRITING, inventory, this.level);
        }
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            WritingRecipe stonecutterRecipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            this.resultContainer.m_6029_((Recipe)stonecutterRecipe);
            this.resultSlot.m_5852_(stonecutterRecipe.m_5874_(this.container));
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return (MenuType)MenuTypeInit.WRITING.get();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            Item item = itemStack2.m_41720_();
            itemStack = itemStack2.m_41777_();
            if (index == 1) {
                item.m_7836_(itemStack2, player.f_19853_, player);
                if (!this.m_38903_(itemStack2, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
            } else if (index == 0 ? !this.m_38903_(itemStack2, 2, 38, false) : (this.level.m_7465_().m_44015_(RecipeType.f_44112_, (Container)new SimpleContainer(new ItemStack[]{itemStack2}), this.level).isPresent() ? !this.m_38903_(itemStack2, 0, 1, false) : (index >= 2 && index < 29 ? !this.m_38903_(itemStack2, 29, 38, false) : index >= 29 && index < 38 && !this.m_38903_(itemStack2, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
            this.m_38946_();
        }
        return itemStack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.access.m_39292_((arg2, arg3) -> this.m_150411_(player, this.container));
    }
}

