/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.items.armor;

import com.google.common.collect.ImmutableMap;
import com.mystic.atlantis.init.ItemInit;
import com.mystic.atlantis.items.armor.BasicArmorMaterial;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemArmorAtlantis
extends ArmorItem {
    private static final Map<ArmorMaterial, MobEffect> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)BasicArmorMaterial.ARMOR_AQUAMARINE, (Object)MobEffects.f_19593_).build();

    public ItemArmorAtlantis(ArmorMaterial material, EquipmentSlot slot, Item.Properties settings) {
        super(material, slot, settings);
    }

    public void m_6883_(@NotNull ItemStack stack, Level world, @NotNull Entity entity, int slot, boolean selected) {
        Player player;
        if (!world.m_5776_() && entity instanceof Player && this.hasFullSuitOfArmorOn(player = (Player)entity)) {
            this.evaluateArmorEffects(player);
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    private void evaluateArmorEffects(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffect> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffect mapStatusEffect = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffect);
        }
    }

    private void addStatusEffectForMaterial(Player player, ArmorMaterial mapArmorMaterial, MobEffect mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect);
        if (this.hasCorrectArmorOn(mapArmorMaterial, player) && !hasPlayerEffect) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect, 200, 1, false, false));
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack breastplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !breastplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    private boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        for (ItemStack armor : player.m_150109_().f_35975_) {
            Item item = armor.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (armorItem.m_40401_() == material) continue;
                return false;
            }
            return false;
        }
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack breastplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return helmet.m_150930_((Item)ItemInit.AQUAMARINE_HELMET.get()) && breastplate.m_150930_((Item)ItemInit.AQUAMARINE_CHESTPLATE.get()) && leggings.m_150930_((Item)ItemInit.AQUAMARINE_LEGGINGS.get()) && boots.m_150930_((Item)ItemInit.AQUAMARINE_BOOTS.get());
    }
}

