/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.mixin;

import com.mystic.atlantis.init.BlockInit;
import com.mystic.atlantis.mixin.RedstoneAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RedStoneWireBlock.class})
public abstract class RedstoneWireBlockMixin {
    @Redirect(method={"shouldConnectTo(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z", ordinal=0))
    private static boolean is(BlockState state, Block block) {
        return state.m_60713_(block) || state.m_60713_((Block)BlockInit.ATLANTEAN_POWER_DUST_WIRE.get());
    }

    @Overwrite
    private int m_55648_(BlockState state) {
        if (state.m_60713_(Blocks.f_50088_)) {
            return (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_);
        }
        if (state.m_60713_((Block)BlockInit.ATLANTEAN_POWER_DUST_WIRE.get())) {
            return (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_);
        }
        return 0;
    }

    @Inject(method={"calculateTargetStrength"}, at={@At(value="HEAD")}, cancellable=true)
    public void setPowerToWires1(Level level, BlockPos targetPos, CallbackInfoReturnable<Integer> cir) {
        cir.cancel();
        ((RedstoneAccessor)((RedStoneWireBlock)this)).setShouldSignal(false);
        int receivedPower = level.m_46755_(targetPos);
        ((RedstoneAccessor)((RedStoneWireBlock)this)).setShouldSignal(true);
        int calculatedPower = 0;
        if (receivedPower >= 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (level.m_8055_(targetPos.m_121945_(direction)).m_222976_().get() != BlockInit.ATLANTEAN_POWER_DUST_WIRE.get() && level.m_8055_(targetPos.m_121945_(direction).m_7495_()).m_222976_().get() != BlockInit.ATLANTEAN_POWER_DUST_WIRE.get() && level.m_8055_(targetPos.m_121945_(direction).m_7494_()).m_222976_().get() != BlockInit.ATLANTEAN_POWER_DUST_WIRE.get()) continue;
                cir.setReturnValue((Object)Math.max(receivedPower - 1, calculatedPower - 1));
            }
            cir.setReturnValue((Object)receivedPower);
        } else if (receivedPower >= 0) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos relativePos = targetPos.m_121945_(direction);
                BlockState relativeState = level.m_8055_(relativePos);
                calculatedPower = Math.max(calculatedPower, this.m_55648_(relativeState));
                BlockPos aboveTargetPos = targetPos.m_7494_();
                if (relativeState.m_60796_((BlockGetter)level, relativePos) && !level.m_8055_(aboveTargetPos).m_60796_((BlockGetter)level, aboveTargetPos)) {
                    calculatedPower = Math.max(calculatedPower, this.m_55648_(level.m_8055_(relativePos.m_7494_())));
                    continue;
                }
                if (relativeState.m_60796_((BlockGetter)level, relativePos)) continue;
                calculatedPower = Math.max(calculatedPower, this.m_55648_(level.m_8055_(relativePos.m_7495_())));
            }
            if (receivedPower == 0) {
                cir.setReturnValue((Object)Math.max(receivedPower, calculatedPower - 1));
            } else {
                cir.setReturnValue((Object)Math.max(receivedPower - 1, calculatedPower - 1));
            }
        } else {
            cir.setReturnValue((Object)0);
        }
    }
}

