/*
 * Decompiled with CFR 0.152.
 */
package com.mystic.atlantis.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mystic.atlantis.Atlantis;
import com.mystic.atlantis.inventory.WritingMenu;
import com.mystic.atlantis.recipes.WritingRecipe;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class WritingScreen
extends AbstractContainerScreen<WritingMenu> {
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("textures/gui/container/stonecutter.png");
    private static final ResourceLocation GRADIENT = Atlantis.id("textures/gui/container/gradient.png");
    private static final ResourceLocation GRADIENT_TOP = Atlantis.id("textures/gui/container/gradient_top.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 52;
    private static final int RECIPES_Y = 14;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public WritingScreen(WritingMenu arg, Inventory arg2, Component arg3) {
        super((AbstractContainerMenu)arg, arg2, arg3);
        arg.registerUpdateListener(this::containerChanged);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG_LOCATION);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(poseStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollOffs);
        this.m_93228_(poseStack, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 52;
        int m = this.f_97736_ + 14;
        int n = this.startIndex + 12;
        this.renderButtons(poseStack, mouseX, mouseY, l, m, n);
        this.renderRecipes(l, m, n);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GRADIENT_TOP);
        this.m_93228_(poseStack, i - 4, j - 4, 0, 0, this.f_97726_ + 7, this.f_97727_ + 7);
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)GRADIENT);
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.m_93228_(poseStack, i - 4, j - 4, 0, 0, this.f_97726_ + 7, this.f_97727_ + 7);
        RenderSystem.m_69461_();
    }

    protected void m_7025_(PoseStack poseStack, int x, int y) {
        super.m_7025_(poseStack, x, y);
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            List<WritingRecipe> list = ((WritingMenu)this.f_97732_).getRecipes();
            for (int l = this.startIndex; l < k && l < ((WritingMenu)this.f_97732_).getNumRecipes(); ++l) {
                int m = l - this.startIndex;
                int n = i + m % 4 * 16;
                int o = j + m / 4 * 18 + 2;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                this.m_6057_(poseStack, list.get(l).m_8043_(), x, y);
            }
        }
    }

    private void renderButtons(PoseStack poseStack, int mouseX, int mouseY, int x, int y, int lastVisibleElementIndex) {
        for (int i = this.startIndex; i < lastVisibleElementIndex && i < ((WritingMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            int n = this.f_97727_;
            if (i == ((WritingMenu)this.f_97732_).getSelectedRecipeIndex()) {
                n += 18;
            } else if (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18) {
                n += 36;
            }
            this.m_93228_(poseStack, k, m - 1, 0, n, 16, 18);
        }
    }

    private void renderRecipes(int left, int top, int recipeIndexOffsetMax) {
        List<WritingRecipe> list = ((WritingMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < recipeIndexOffsetMax && i < ((WritingMenu)this.f_97732_).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int m = top + l * 18 + 2;
            this.f_96541_.m_91291_().m_115203_(list.get(i).m_8043_(), k, m);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int m = l - this.startIndex;
                double d = mouseX - (double)(i + m % 4 * 16);
                double e = mouseY - (double)(j + m / 4 * 18);
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((WritingMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l))) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((WritingMenu)this.f_97732_).f_38840_, l);
                return true;
            }
            i = this.f_97735_ + 119;
            j = this.f_97736_ + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.scrollOffs = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - delta / (double)i);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((WritingMenu)this.f_97732_).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((WritingMenu)this.f_97732_).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((WritingMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

