/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImprovedProjectileEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.m_135353_(ImprovedProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected boolean touchedGround = false;
    protected int groundTime = 0;
    protected int maxAge = 200;
    protected int maxGroundTime = 20;
    protected float waterDeceleration = 0.8f;

    protected ImprovedProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, Level world) {
        super(type, world);
    }

    protected ImprovedProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, double x, double y, double z, Level world) {
        this(type, world);
        this.m_6034_(x, y, z);
    }

    protected ImprovedProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, LivingEntity thrower, Level world) {
        this(type, thrower.m_20185_(), thrower.m_20188_() - (double)0.1f, thrower.m_20189_(), world);
        this.m_5602_((Entity)thrower);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FLAGS, (Object)0);
    }

    private void setFlag(int id, boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(ID_FLAGS);
        if (value) {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)(b0 | id)));
        } else {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)(b0 & ~id)));
        }
    }

    public void setNoPhysics(boolean noPhysics) {
        this.f_19794_ = noPhysics;
        this.setFlag(2, noPhysics);
    }

    public boolean isNoPhysics() {
        if (!this.f_19853_.f_46443_) {
            return this.f_19794_;
        }
        return ((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 2) != 0;
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        this.m_6075_();
        if (!this.f_150164_) {
            this.m_146852_(GameEvent.f_157778_, this.m_37282_());
            this.f_150164_ = true;
        }
        Vec3 movement = this.m_20184_();
        double velX = movement.f_82479_;
        double velY = movement.f_82480_;
        double velZ = movement.f_82481_;
        boolean noPhysics = this.isNoPhysics();
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.f_19853_.m_8055_(blockpos);
        if (!(blockstate.m_60795_() || noPhysics || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vector3d1 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vector3d1)) continue;
                this.touchedGround = true;
                break;
            }
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        if (this.touchedGround && !noPhysics) {
            ++this.groundTime;
        } else {
            this.groundTime = 0;
            this.m_37283_();
            Vec3 pos = this.m_20182_();
            boolean client = this.f_19853_.f_46443_;
            Vec3 newPos = pos.m_82549_(movement);
            BlockHitResult blockHitResult = this.f_19853_.m_45547_(new ClipContext(pos, newPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (blockHitResult.m_6662_() != HitResult.Type.MISS && !noPhysics) {
                newPos = blockHitResult.m_82450_();
            }
            if (client) {
                this.spawnTrailParticles(pos, newPos);
            }
            double posX = newPos.f_82479_;
            double posY = newPos.f_82480_;
            double posZ = newPos.f_82481_;
            if (!this.m_20068_() && !noPhysics) {
                this.m_20334_(velX, velY - (double)this.m_7139_(), velZ);
            }
            float deceleration = this.getDeceleration();
            if (this.m_20069_()) {
                if (client) {
                    for (int j = 0; j < 4; ++j) {
                        double pY = posY + (double)this.m_20206_() / 2.0;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, posX - velX * 0.25, pY - velY * 0.25, posZ - velZ * 0.25, velX, velY, velZ);
                    }
                }
                deceleration = this.waterDeceleration;
            }
            this.m_20256_(this.m_20184_().m_82490_((double)deceleration));
            this.m_6034_(posX, posY, posZ);
            this.m_20101_();
            if (!this.m_213877_()) {
                EntityHitResult hitEntity = this.findHitEntity(pos, newPos);
                if (hitEntity != null) {
                    blockHitResult = hitEntity;
                }
                HitResult.Type type = blockHitResult.m_6662_();
                boolean portalHit = false;
                if (type == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)blockHitResult).m_82443_();
                    if (entity instanceof Player) {
                        Player p2;
                        Player p1 = (Player)entity;
                        Entity entity2 = this.m_37282_();
                        if (entity2 instanceof Player && !(p2 = (Player)entity2).m_7099_(p1)) {
                            blockHitResult = null;
                        }
                    }
                } else if (type == HitResult.Type.BLOCK) {
                    BlockPos hitPos = blockHitResult.m_82425_();
                    BlockState hitState = this.f_19853_.m_8055_(hitPos);
                    if (hitState.m_60713_(Blocks.f_50142_)) {
                        this.m_20221_(hitPos);
                        portalHit = true;
                    } else if (hitState.m_60713_(Blocks.f_50446_)) {
                        BlockEntity blockEntity = this.f_19853_.m_7702_(hitPos);
                        if (blockEntity instanceof TheEndGatewayBlockEntity) {
                            TheEndGatewayBlockEntity tile = (TheEndGatewayBlockEntity)blockEntity;
                            if (TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                                TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)hitPos, (BlockState)hitState, (Entity)this, (TheEndGatewayBlockEntity)tile);
                            }
                        }
                        portalHit = true;
                    }
                }
                if (!(portalHit || blockHitResult == null || type == HitResult.Type.MISS || noPhysics || ForgeHelper.onProjectileImpact((Projectile)this, (HitResult)blockHitResult))) {
                    this.m_6532_((HitResult)blockHitResult);
                    this.f_19812_ = true;
                }
            }
        }
        if (this.hasReachedEndOfLife() && !this.m_213877_()) {
            this.reachedEndOfLife();
        }
    }

    protected float getDeceleration() {
        return 0.99f;
    }

    public boolean hasReachedEndOfLife() {
        return this.f_19797_ > this.maxAge || this.groundTime > this.maxGroundTime;
    }

    public void reachedEndOfLife() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 oPos, Vec3 pos) {
        return ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)oPos, (Vec3)pos, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), x$0 -> this.m_5603_((Entity)x$0));
    }

    public void spawnTrailParticles(Vec3 currentPos, Vec3 newPos) {
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("touchedGround", this.touchedGround);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.touchedGround = tag.m_128471_("touchedGround");
    }
}

