/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.fake_player.FakeServerPlayer;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.criteria_triggers.ModCriteriaTriggers;
import net.mehvahdjukaar.moonlight.core.loot_pool_entries.ModLootPoolEntries;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.VillagerAIInternal;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.mehvahdjukaar.moonlight.core.set.BlocksColorInternal;
import net.mehvahdjukaar.moonlight.core.set.CompatTypes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Moonlight {
    public static final String MOD_ID = "moonlight";
    public static final Logger LOGGER = LogManager.getLogger((String)"moonlight");
    public static final boolean HAS_BEEN_INIT = true;
    public static final TagKey<Block> SHEARABLE_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("mineable/shear"));

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        BlockSetInternal.registerBlockSetDefinition(WoodTypeRegistry.INSTANCE);
        BlockSetInternal.registerBlockSetDefinition(LeavesTypeRegistry.INSTANCE);
        CompatTypes.init();
        ModMessages.registerMessages();
        ModCriteriaTriggers.register();
        ModLootPoolEntries.register();
        VillagerAIInternal.init();
        SoftFluidRegistry.init();
        MapDataInternal.init();
        if (PlatformHelper.getEnv().isClient()) {
            MoonlightClient.initClient();
        }
        PlatformHelper.addCommonSetup(BlocksColorInternal::setup);
        PlatformHelper.addCommonSetup(Moonlight::commonSetup);
    }

    private static void commonSetup() {
        BlocksColorInternal.setup();
        FakeServerPlayer.init();
    }

    public static void onPlayerCloned(Player oldPlayer, Player newPlayer, boolean wasDeath) {
        if (wasDeath && !oldPlayer.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            Inventory inv = oldPlayer.m_150109_();
            int i = 0;
            for (ItemStack v : inv.f_35974_) {
                if (v != ItemStack.f_41583_) {
                    IDropItemOnDeathEvent e = IDropItemOnDeathEvent.create(v, oldPlayer, false);
                    MoonlightEventsHelper.postEvent(e, IDropItemOnDeathEvent.class);
                    if (e.isCanceled()) {
                        newPlayer.m_150109_().m_6836_(i, e.getReturnItemStack());
                    }
                }
                ++i;
            }
        }
    }

    public static MapItemSavedData getMapDataFromKnownKeys(ServerLevel level, int mapId) {
        MapItemSavedData d = level.m_7489_(MapItem.m_42848_((int)mapId));
        if (d == null && (d = level.m_7489_("magicmap_" + mapId)) == null) {
            d = level.m_7489_("mazemap_" + mapId);
        }
        return d;
    }
}

