/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.corelib.block.IItemBlock;
import de.maxhenkel.easyvillagers.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.easyvillagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;

public abstract class TraderBlockBase
extends VillagerBlockBase
implements EntityBlock,
IItemBlock {
    public TraderBlockBase() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.5f).m_60918_(SoundType.f_56743_).m_60955_());
    }

    @Override
    public abstract Item toItem();

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (!(tileEntity instanceof TraderTileentityBase)) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        TraderTileentityBase trader = (TraderTileentityBase)tileEntity;
        if (!trader.hasVillager() && heldItem.m_41720_() instanceof VillagerItem) {
            trader.setVillager(heldItem.m_41777_());
            ItemUtils.decrItemStack(heldItem, player);
            if (trader.hasWorkstation()) {
                EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
                if (villagerEntity != null) {
                    this.playWorkstationSound(worldIn, pos, trader);
                }
            } else {
                TraderBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12504_);
            }
            return InteractionResult.SUCCESS;
        }
        if (!trader.hasWorkstation() && heldItem.m_41720_() instanceof BlockItem && trader.isValidBlock(((BlockItem)heldItem.m_41720_()).m_40614_())) {
            Block block = ((BlockItem)heldItem.m_41720_()).m_40614_();
            trader.setWorkstation(block);
            ItemUtils.decrItemStack(heldItem, player);
            EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
            if (villagerEntity != null) {
                this.playWorkstationSound(worldIn, pos, trader);
            }
            SoundType type = block.m_49962_(block.m_49966_());
            worldIn.m_5594_(null, pos, type.m_56777_(), SoundSource.BLOCKS, type.m_56773_(), type.m_56774_());
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && trader.hasVillager()) {
            ItemStack stack = trader.removeVillager();
            if (heldItem.m_41619_()) {
                player.m_21008_(handIn, stack);
            } else if (!player.m_150109_().m_36054_(stack)) {
                Direction direction = (Direction)state.m_61143_((Property)FACING);
                Containers.m_18992_((Level)worldIn, (double)((double)(direction.m_122429_() + pos.m_123341_()) + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)(direction.m_122431_() + pos.m_123343_()) + 0.5), (ItemStack)stack);
            }
            TraderBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12504_);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && trader.hasWorkstation()) {
            ItemStack blockStack = new ItemStack((ItemLike)trader.removeWorkstation());
            if (heldItem.m_41619_()) {
                player.m_21008_(handIn, blockStack);
            } else if (!player.m_150109_().m_36054_(blockStack)) {
                Direction direction = (Direction)state.m_61143_((Property)FACING);
                Containers.m_18992_((Level)worldIn, (double)((double)(direction.m_122429_() + pos.m_123341_()) + 0.5), (double)((double)pos.m_123342_() + 0.5), (double)((double)(direction.m_122431_() + pos.m_123343_()) + 0.5), (ItemStack)blockStack);
            }
            if (trader.hasVillager()) {
                TraderBlockBase.playVillagerSound(worldIn, pos, SoundEvents.f_12507_);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.openGUI(trader, player, worldIn, pos)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    protected abstract boolean openGUI(TraderTileentityBase var1, Player var2, Level var3, BlockPos var4);

    protected void playWorkstationSound(Level world, BlockPos pos, TraderTileentityBase trader) {
        EasyVillagerEntity villagerEntity = trader.getVillagerEntity();
        if (villagerEntity != null) {
            if (trader.getWorkstationProfession().equals((Object)villagerEntity.m_7141_().m_35571_())) {
                TraderBlockBase.playVillagerSound(world, pos, trader.getWorkstationProfession().f_35604_());
            } else {
                TraderBlockBase.playVillagerSound(world, pos, SoundEvents.f_12507_);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level1, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    @Nullable
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }
}

