/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ProgressArrowElement;

public enum FurnaceProvider implements IBlockComponentProvider,
IServerDataProvider<BlockEntity>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (!data.m_128441_("progress")) {
            return;
        }
        int progress = data.m_128451_("progress");
        ListTag furnaceItems = data.m_128437_("furnace", 10);
        NonNullList inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        for (int i = 0; i < furnaceItems.size(); ++i) {
            inventory.set(i, (Object)ItemStack.m_41712_((CompoundTag)furnaceItems.m_128728_(i)));
        }
        IElementHelper helper = IElementHelper.get();
        int total = data.m_128451_("total");
        tooltip.add(helper.item((ItemStack)inventory.get(0)));
        tooltip.append(helper.item((ItemStack)inventory.get(1)));
        tooltip.append(new ProgressArrowElement((float)progress / (float)total));
        tooltip.append(helper.item((ItemStack)inventory.get(2)));
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity blockEntity, boolean showDetails) {
        AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)blockEntity;
        if (furnace.m_7983_()) {
            return;
        }
        ListTag items = new ListTag();
        for (int i = 0; i < 3; ++i) {
            items.add((Object)furnace.m_8020_(i).m_41739_(new CompoundTag()));
        }
        data.m_128365_("furnace", (Tag)items);
        CompoundTag furnaceTag = furnace.m_187482_();
        data.m_128405_("progress", furnaceTag.m_128451_("CookTime"));
        data.m_128405_("total", furnaceTag.m_128451_("CookTimeTotal"));
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_FURNACE;
    }
}

