/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TheEndGatewayBlockEntity.class})
public abstract class TheEndGatewayBlockEntityMixin {
    @Unique
    private static final TagKey<Block> CANNOT_PLACE_ON = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("betterendisland", "end_gateway_cannot_place_player_on"));

    @Inject(method={"findTallestBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private static void betterendisland_findTallestBlock(BlockGetter level, BlockPos pos, int radius, boolean placeAnywhere, CallbackInfoReturnable<BlockPos> cir) {
        BlockPos targetPos = null;
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            block1: for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                if (xOffset == 0 && zOffset == 0 && !placeAnywhere) continue;
                for (int y = level.m_151558_() - 1; y > (targetPos == null ? level.m_141937_() : targetPos.m_123342_()); --y) {
                    BlockPos candidatePos = new BlockPos(pos.m_123341_() + xOffset, y, pos.m_123343_() + zOffset);
                    BlockState blockState = level.m_8055_(candidatePos);
                    if (!blockState.m_60838_(level, candidatePos) || !placeAnywhere && blockState.m_204336_(CANNOT_PLACE_ON)) continue;
                    targetPos = candidatePos;
                    continue block1;
                }
            }
        }
        cir.setReturnValue((Object)(targetPos == null ? pos : targetPos));
    }

    @Inject(method={"findValidSpawnInChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private static void betterendisland_findValidSpawnInChunk(LevelChunk chunk, CallbackInfoReturnable<BlockPos> cir) {
        ChunkPos chunkPos = chunk.m_7697_();
        BlockPos minPos = new BlockPos(chunkPos.m_45604_(), 30, chunkPos.m_45605_());
        int maxY = chunk.m_62098_() + 16 - 1;
        BlockPos maxPos = new BlockPos(chunkPos.m_45608_(), maxY, chunkPos.m_45609_());
        BlockPos chosenPos = null;
        double minDistance = 0.0;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockState blockState = chunk.m_8055_(pos);
            BlockPos above = pos.m_7494_();
            BlockPos above2 = pos.m_6630_(2);
            if (!blockState.m_60713_(Blocks.f_50259_) || !chunk.m_8055_(above).m_60795_() || !chunk.m_8055_(above2).m_60795_()) continue;
            double distance = pos.m_203198_(0.0, 0.0, 0.0);
            if (chosenPos != null && !(distance < minDistance)) continue;
            chosenPos = pos;
            minDistance = distance;
        }
        cir.setReturnValue(chosenPos);
    }
}

