/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world;

import com.google.common.collect.ImmutableList;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DragonRespawnStage implements StringRepresentable
{
    START("start"){

        @Override
        public void tick(ServerLevel level, EndDragonFight dragonFight, List<EndCrystal> summoningCrystals, int phaseTimer, BlockPos portalPos) {
            BlockPos beamTargetPos = new BlockPos(0, 128, 0);
            summoningCrystals.forEach(crystal -> crystal.m_31052_(beamTargetPos));
            ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(PREPARING_TO_SUMMON_PILLARS);
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS("preparing_to_summon_pillars"){

        @Override
        public void tick(ServerLevel level, EndDragonFight dragonFight, List<EndCrystal> summoningCrystals, int phaseTimer, BlockPos portalPos) {
            int totalPhaseTime = 100;
            if (phaseTimer < totalPhaseTime) {
                if (phaseTimer == 0 || phaseTimer == 50 || phaseTimer == 51 || phaseTimer == 52 || phaseTimer >= 95) {
                    DragonRespawnStage.broadcastDragonGrowlSound(level);
                }
            } else {
                ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(SUMMONING_PILLARS);
            }
        }
    }
    ,
    SUMMONING_PILLARS("summoning_pillars"){

        @Override
        public void tick(ServerLevel level, EndDragonFight dragonFight, List<EndCrystal> summoningCrystals, int phaseTimer, BlockPos portalPos) {
            boolean isLastTickForSpike;
            int ticksPerSpike = 40;
            boolean isFirstTickForSpike = phaseTimer % ticksPerSpike == 0;
            boolean bl = isLastTickForSpike = phaseTimer % ticksPerSpike == 39;
            if (isFirstTickForSpike || isLastTickForSpike) {
                int spikeIndex = phaseTimer / ticksPerSpike;
                List allSpikes = SpikeFeature.m_66858_((WorldGenLevel)level);
                if (spikeIndex < allSpikes.size()) {
                    SpikeFeature.EndSpike spike = (SpikeFeature.EndSpike)allSpikes.get(spikeIndex);
                    int pillarHeight = (spike.m_66899_() - 73) / 3;
                    if (pillarHeight == 10) {
                        pillarHeight = 9;
                    }
                    ((IEndSpike)spike).betterendisland$setCrystalYOffsetFromPillarHeight(pillarHeight);
                    int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
                    int crystalY = topY + ((IEndSpike)spike).betterendisland$getCrystalYOffset() - 1;
                    if (isFirstTickForSpike) {
                        for (EndCrystal crystal : summoningCrystals) {
                            crystal.m_31052_(new BlockPos(spike.m_66886_(), crystalY, spike.m_66893_()));
                        }
                    } else {
                        level.m_46511_(null, (double)((float)spike.m_66886_() + 0.5f), (double)crystalY, (double)((float)spike.m_66893_() + 0.5f), 5.0f, Explosion.BlockInteraction.DESTROY);
                        level.m_6907_().forEach(player -> {
                            level.m_8624_(player, (ParticleOptions)ParticleTypes.f_123812_, true, (double)((float)spike.m_66886_() - 5.0f), (double)crystalY, (double)((float)spike.m_66893_() - 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            level.m_8624_(player, (ParticleOptions)ParticleTypes.f_123812_, true, (double)((float)spike.m_66886_() - 5.0f), (double)crystalY, (double)((float)spike.m_66893_() + 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            level.m_8624_(player, (ParticleOptions)ParticleTypes.f_123812_, true, (double)((float)spike.m_66886_() + 5.0f), (double)crystalY, (double)((float)spike.m_66893_() - 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            level.m_8624_(player, (ParticleOptions)ParticleTypes.f_123812_, true, (double)((float)spike.m_66886_() + 5.0f), (double)crystalY, (double)((float)spike.m_66893_() + 5.0f), 1, 0.0, 0.0, 0.0, 0.0);
                            if (player.m_20275_((double)spike.m_66886_(), (double)crystalY, (double)spike.m_66893_()) > 32.0) {
                                level.m_5594_(null, new BlockPos(spike.m_66886_(), crystalY, spike.m_66893_()), SoundEvents.f_11913_, SoundSource.NEUTRAL, 24.0f, 1.0f);
                            }
                        });
                        int resetRadius = 11;
                        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)new BlockPos(spike.m_66886_() - resetRadius, spike.m_66899_() - 30, spike.m_66893_() - resetRadius), (BlockPos)new BlockPos(spike.m_66886_() + resetRadius, spike.m_66899_() + 30, spike.m_66893_() + resetRadius))) {
                            if (level.m_8055_(blockPos).m_60713_(Blocks.f_50259_)) continue;
                            level.m_7471_(blockPos, false);
                        }
                        SpikeConfiguration spikeConfig = new SpikeConfiguration(true, (List)ImmutableList.of((Object)spike), new BlockPos(0, 128, 0));
                        Feature.f_65732_.m_225028_((FeatureConfiguration)spikeConfig, (WorldGenLevel)level, level.m_7726_().m_8481_(), RandomSource.m_216327_(), new BlockPos(spike.m_66886_(), 45, spike.m_66893_()));
                    }
                } else if (isFirstTickForSpike) {
                    ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(SUMMONING_DRAGON);
                }
            }
        }
    }
    ,
    SUMMONING_DRAGON("summoning_dragon"){

        @Override
        public void tick(ServerLevel level, EndDragonFight dragonFight, List<EndCrystal> summoningCrystals, int phaseTimer, BlockPos portalPos) {
            int totalPhaseTime = 100;
            if (phaseTimer >= totalPhaseTime) {
                ((IDragonFight)dragonFight).betterendisland$setDragonRespawnStage(END);
                dragonFight.m_64101_();
                for (EndCrystal crystal : summoningCrystals) {
                    crystal.m_31052_(null);
                    level.m_46511_((Entity)crystal, crystal.m_20185_(), crystal.m_20186_(), crystal.m_20189_(), 6.0f, Explosion.BlockInteraction.NONE);
                    crystal.m_146870_();
                }
            } else if (phaseTimer >= 80) {
                DragonRespawnStage.broadcastDragonGrowlSound(level);
            } else if (phaseTimer == 0) {
                for (EndCrystal crystal : summoningCrystals) {
                    crystal.m_31052_(new BlockPos(0, 128, 0));
                }
            } else if (phaseTimer < 5) {
                DragonRespawnStage.broadcastDragonGrowlSound(level);
            }
        }
    }
    ,
    END("end"){

        @Override
        public void tick(ServerLevel level, EndDragonFight dragonFight, List<EndCrystal> summoningCrystals, int phaseTimer, BlockPos portalPos) {
        }
    };

    public static final StringRepresentable.EnumCodec<DragonRespawnStage> CODEC;
    private final String name;

    @Nullable
    public static DragonRespawnStage byName(@Nullable String name) {
        return (DragonRespawnStage)CODEC.m_216455_(name);
    }

    private DragonRespawnStage(String name) {
        this.name = name.toLowerCase();
    }

    public String m_7912_() {
        return this.name;
    }

    private static void broadcastDragonGrowlSound(ServerLevel level) {
        level.m_46796_(3001, new BlockPos(0, 128, 0), 0);
    }

    public abstract void tick(ServerLevel var1, EndDragonFight var2, List<EndCrystal> var3, int var4, BlockPos var5);

    static {
        CODEC = StringRepresentable.m_216439_(DragonRespawnStage::values);
    }
}

