/*
 * Decompiled with CFR 0.152.
 */
package com.github.raverbury.aggroindicator.event;

import com.github.raverbury.aggroindicator.AlertRenderer;
import com.github.raverbury.aggroindicator.config.ClientConfig;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientEventHandler {
    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ClientEventHandler::handleRenderLivingEvent);
        MinecraftForge.EVENT_BUS.addListener(ClientEventHandler::handleRenderLevelStageEvent);
    }

    public static void handleRenderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<?>> event) {
        if (event.isCanceled() || !event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        if (!ClientEventHandler.shouldDrawAlert(event.getEntity())) {
            return;
        }
        AlertRenderer.addEntity(event.getEntity());
    }

    public static void handleRenderLevelStageEvent(RenderLevelStageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        AlertRenderer.renderAlertIcon(event.getPartialTick(), event.getPoseStack(), Minecraft.m_91087_().f_91063_.m_109153_());
    }

    public static boolean shouldDrawAlert(LivingEntity renderedEntity) {
        boolean PLAYER_HAS_STATUS_BLINDNESS_OR_DARKNESS;
        boolean ENTITY_IS_INVISIBLE;
        boolean NOT_A_MOB;
        boolean TOO_FAR_AWAY;
        if (!((Boolean)ClientConfig.RENDER_ALERT_ICON.get()).booleanValue()) {
            return false;
        }
        Minecraft minecraftClient = Minecraft.m_91087_();
        Entity cameraEntity = minecraftClient.m_91288_();
        boolean bl = TOO_FAR_AWAY = cameraEntity == null || renderedEntity.m_20270_(cameraEntity) > (float)((Integer)ClientConfig.RENDER_RANGE.get()).intValue();
        if (TOO_FAR_AWAY) {
            return false;
        }
        boolean bl2 = NOT_A_MOB = !(renderedEntity instanceof Mob);
        if (NOT_A_MOB) {
            return false;
        }
        String entityRegistryName = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)renderedEntity.m_6095_())).toString();
        boolean IS_BLACKLISTED = false;
        for (String item : (List)ClientConfig.CLIENT_MOB_BLACKLIST.get()) {
            Pattern pattern = Pattern.compile(item = item.replace("*", ".*"), 2);
            if (!pattern.matcher(entityRegistryName).matches()) continue;
            IS_BLACKLISTED = true;
            break;
        }
        if (IS_BLACKLISTED) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean bl3 = ENTITY_IS_INVISIBLE = player == null || renderedEntity.m_20177_((Player)player);
        if (ENTITY_IS_INVISIBLE) {
            return false;
        }
        boolean IS_TARGETING_CLIENT_PLAYER = AlertRenderer.shouldDrawThisUuid(renderedEntity.m_20148_());
        if (!IS_TARGETING_CLIENT_PLAYER) {
            return false;
        }
        boolean bl4 = PLAYER_HAS_STATUS_BLINDNESS_OR_DARKNESS = player.m_21023_(MobEffects.f_19610_) || player.m_21023_(MobEffects.f_216964_);
        return !PLAYER_HAS_STATUS_BLINDNESS_OR_DARKNESS;
    }
}

