/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.noisium.mixin;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={NoiseBasedChunkGenerator.class})
public abstract class NoiseChunkGeneratorMixin
extends ChunkGenerator {
    @Shadow
    @Final
    public Holder<NoiseGeneratorSettings> f_64318_;

    public NoiseChunkGeneratorMixin(Registry<StructureSet> p_207960_, Optional<HolderSet<StructureSet>> p_207961_, BiomeSource p_207962_) {
        super(p_207960_, p_207961_, p_207962_);
    }

    @Overwrite
    private ChunkAccess m_224284_(Blender blender, StructureManager structureAccessor, RandomState noiseConfig, ChunkAccess chunk, int minimumCellY, int cellHeight) {
        NoiseChunk chunkNoiseSampler = chunk.m_223012_(chunk2 -> ((NoiseBasedChunkGenerator)this).m_224256_(chunk2, structureAccessor, blender, noiseConfig));
        Heightmap oceanFloorHeightMap = chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap worldSurfaceHeightMap = chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkPos = chunk.m_7697_();
        int chunkPosStartX = chunkPos.m_45604_();
        int chunkPosStartZ = chunkPos.m_45605_();
        Aquifer aquiferSampler = chunkNoiseSampler.m_188817_();
        chunkNoiseSampler.m_188791_();
        int horizontalCellBlockCount = chunkNoiseSampler.m_224362_();
        int verticalCellBlockCount = chunkNoiseSampler.m_224363_();
        int horizontalCellCount = 16 / horizontalCellBlockCount;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int baseHorizontalWidthCellIndex = 0; baseHorizontalWidthCellIndex < horizontalCellCount; ++baseHorizontalWidthCellIndex) {
            chunkNoiseSampler.m_188749_(baseHorizontalWidthCellIndex);
            for (int baseHorizontalLengthCellIndex = 0; baseHorizontalLengthCellIndex < horizontalCellCount; ++baseHorizontalLengthCellIndex) {
                int nextChunkSectionIndex = chunk.m_151559_() - 1;
                LevelChunkSection chunkSection = chunk.m_183278_(nextChunkSectionIndex);
                for (int verticalCellHeightIndex = cellHeight - 1; verticalCellHeightIndex >= 0; --verticalCellHeightIndex) {
                    chunkNoiseSampler.m_188810_(verticalCellHeightIndex, baseHorizontalLengthCellIndex);
                    for (int verticalCellBlockIndex = verticalCellBlockCount - 1; verticalCellBlockIndex >= 0; --verticalCellBlockIndex) {
                        int blockPosY = (minimumCellY + verticalCellHeightIndex) * verticalCellBlockCount + verticalCellBlockIndex;
                        int chunkSectionBlockPosY = blockPosY & 0xF;
                        int chunkSectionIndex = chunk.m_151564_(blockPosY);
                        if (nextChunkSectionIndex != chunkSectionIndex) {
                            nextChunkSectionIndex = chunkSectionIndex;
                            chunkSection = chunk.m_183278_(chunkSectionIndex);
                        }
                        double deltaY = (double)verticalCellBlockIndex / (double)verticalCellBlockCount;
                        chunkNoiseSampler.m_209191_(blockPosY, deltaY);
                        for (int horizontalWidthCellBlockIndex = 0; horizontalWidthCellBlockIndex < horizontalCellBlockCount; ++horizontalWidthCellBlockIndex) {
                            int blockPosX = chunkPosStartX + baseHorizontalWidthCellIndex * horizontalCellBlockCount + horizontalWidthCellBlockIndex;
                            int chunkSectionBlockPosX = blockPosX & 0xF;
                            double deltaX = (double)horizontalWidthCellBlockIndex / (double)horizontalCellBlockCount;
                            chunkNoiseSampler.m_209230_(blockPosX, deltaX);
                            for (int horizontalLengthCellBlockIndex = 0; horizontalLengthCellBlockIndex < horizontalCellBlockCount; ++horizontalLengthCellBlockIndex) {
                                int blockPosZ = chunkPosStartZ + baseHorizontalLengthCellIndex * horizontalCellBlockCount + horizontalLengthCellBlockIndex;
                                int chunkSectionBlockPosZ = blockPosZ & 0xF;
                                double deltaZ = (double)horizontalLengthCellBlockIndex / (double)horizontalCellBlockCount;
                                chunkNoiseSampler.m_209241_(blockPosZ, deltaZ);
                                BlockState blockState = chunkNoiseSampler.m_209247_();
                                if (blockState == null) {
                                    blockState = ((NoiseGeneratorSettings)((NoiseBasedChunkGenerator)this).f_64318_.m_203334_()).f_64440_();
                                }
                                if (blockState == NoiseBasedChunkGenerator.f_64321_ || SharedConstants.m_183707_((ChunkPos)chunk.m_7697_())) continue;
                                chunkSection.f_62969_ = (short)(chunkSection.f_62969_ + 1);
                                if (!blockState.m_60819_().m_76178_()) {
                                    chunkSection.f_62971_ = (short)(chunkSection.f_62971_ + 1);
                                }
                                if (blockState.m_60823_()) {
                                    chunkSection.f_62970_ = (short)(chunkSection.f_62970_ + 1);
                                }
                                int blockStateId = chunkSection.f_62972_.f_188032_.f_188102_.m_6796_((Object)blockState);
                                chunkSection.f_62972_.f_188032_.f_188101_().m_13524_(chunkSection.f_62972_.f_188033_.m_188145_(chunkSectionBlockPosX, chunkSectionBlockPosY, chunkSectionBlockPosZ), blockStateId);
                                oceanFloorHeightMap.m_64249_(chunkSectionBlockPosX, blockPosY, chunkSectionBlockPosZ, blockState);
                                worldSurfaceHeightMap.m_64249_(chunkSectionBlockPosX, blockPosY, chunkSectionBlockPosZ, blockState);
                                if (!aquiferSampler.m_142203_() || blockState.m_60819_().m_76178_()) continue;
                                mutableBlockPos.m_122178_(blockPosX, blockPosY, blockPosZ);
                                chunk.m_8113_((BlockPos)mutableBlockPos);
                            }
                        }
                    }
                }
            }
            chunkNoiseSampler.m_188804_();
        }
        chunkNoiseSampler.m_209248_();
        return chunk;
    }

    @Overwrite
    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState noiseConfig, StructureManager structureAccessor, ChunkAccess chunk) {
        NoiseSettings generationShapeConfig = ((NoiseGeneratorSettings)this.f_64318_.m_203334_()).f_64439_().m_224530_(chunk.m_183618_());
        int minimumY = generationShapeConfig.f_158688_();
        int generationShapeHeightFloorDiv = Math.floorDiv(generationShapeConfig.f_64508_(), generationShapeConfig.m_189212_());
        if (generationShapeHeightFloorDiv <= 0) {
            return CompletableFuture.completedFuture(chunk);
        }
        int minimumYFloorDiv = Math.floorDiv(minimumY, generationShapeConfig.m_189212_());
        int startingChunkSectionIndex = chunk.m_151564_(generationShapeHeightFloorDiv * generationShapeConfig.m_189212_() - 1 + minimumY);
        int minimumYChunkSectionIndex = chunk.m_151564_(minimumY);
        ArrayList<LevelChunkSection> chunkSections = new ArrayList<LevelChunkSection>();
        for (int chunkSectionIndex = startingChunkSectionIndex; chunkSectionIndex >= minimumYChunkSectionIndex; --chunkSectionIndex) {
            LevelChunkSection chunkSection = chunk.m_183278_(chunkSectionIndex);
            chunkSection.m_62981_();
            chunkSections.add(chunkSection);
        }
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"wgen_fill_noise", () -> this.m_224284_(blender, structureAccessor, noiseConfig, chunk, minimumYFloorDiv, generationShapeHeightFloorDiv)), Util.m_183991_()).whenCompleteAsync((chunk2, throwable) -> {
            for (int i = 0; i < chunkSections.size(); ++i) {
                ((LevelChunkSection)chunkSections.get(i)).m_63006_();
            }
        }, executor);
    }
}

