/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.BetterTags;

import com.mojang.brigadier.CommandDispatcher;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;
import wallywhip.BetterTags.initConfigs;
import wallywhip.BetterTags.nbtCommands;

@Mod(value="bettertags")
public class BetterTags {
    public static final String MOD_ID = "bettertags";
    public static final initConfigs CONFIGURATION = new initConfigs();

    public BetterTags() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BetterTags.CONFIGURATION.CLIENT);
        System.setProperty("java.awt.headless", "false");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void ItemToolTipEvent(ItemTooltipEvent event) {
        String st;
        LocalPlayer player;
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_41619_()) {
            return;
        }
        boolean showStuff = true;
        if (((Boolean)BetterTags.CONFIGURATION.showAsAdvanced.get()).booleanValue()) {
            showStuff = Minecraft.m_91087_().f_91066_.f_92125_;
        }
        if (showStuff) {
            Object st2;
            int BurnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null);
            if (BurnTime > 0) {
                st2 = BetterTags.getTimeStringShort(BurnTime / 20) + " (" + BurnTime + ")";
                event.getToolTip().add(1, Component.m_237110_((String)"tip.bettertags.burn", (Object[])new Object[]{st2}).m_130940_(ChatFormatting.GRAY));
            }
            if (itemStack.m_41782_()) {
                if (itemStack.m_41776_() != 0 && itemStack.m_41773_() == 0) {
                    event.getToolTip().add(1, Component.m_237110_((String)"tip.bettertags.durability", (Object[])new Object[]{itemStack.m_41776_()}).m_130940_(ChatFormatting.GRAY));
                }
                if (Screen.m_96637_()) {
                    if (((Boolean)BetterTags.CONFIGURATION.showNBTLength.get()).booleanValue()) {
                        event.getToolTip().add(Component.m_237110_((String)"tip.bettertags.length", (Object[])new Object[]{BetterTags.getNBTSize(itemStack.m_41783_())}).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                    st2 = itemStack.m_41783_().toString();
                    int l = 200;
                    if (((String)st2).length() > l) {
                        event.getToolTip().add(Component.m_237113_((String)((String)st2).substring(0, l)).m_130940_(ChatFormatting.DARK_GRAY));
                        event.getToolTip().add(Component.m_237110_((String)"tip.bettertags.more", (Object[])new Object[]{((String)st2).length() - l}).m_130940_(ChatFormatting.DARK_GRAY));
                    } else {
                        event.getToolTip().add(Component.m_237113_((String)st2).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tip.bettertags.ctrl", (Object[])new Object[]{Component.m_237115_((String)"tip.ctrl").m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GRAY));
                }
            }
            Collection<ResourceLocation> iTag = BetterTags.getTags(itemStack.m_204131_());
            if (Screen.m_96638_()) {
                Block block;
                if (iTag.size() > 0) {
                    event.getToolTip().add(Component.m_237115_((String)"tip.bettertags.item_tags").m_130940_(ChatFormatting.GRAY));
                    iTag.forEach(tag -> event.getToolTip().add(Component.m_237113_((String)("  #" + tag.toString())).m_130940_(ChatFormatting.DARK_GRAY)));
                }
                if ((block = Block.m_49814_((Item)itemStack.m_41720_())) != Blocks.f_50016_ && (iTag = BetterTags.getTags(block.m_49966_().m_204343_())).size() > 0) {
                    event.getToolTip().add(Component.m_237115_((String)"tip.bettertags.block_tags").m_130940_(ChatFormatting.GRAY));
                    iTag.forEach(tag -> event.getToolTip().add(Component.m_237113_((String)("  #" + tag)).m_130940_(ChatFormatting.DARK_GRAY)));
                }
            } else {
                Block block;
                if (iTag.size() == 0 && (block = Block.m_49814_((Item)itemStack.m_41720_())) != Blocks.f_50016_) {
                    iTag = BetterTags.getTags(block.m_49966_().m_204343_());
                }
                if (iTag.size() > 0) {
                    event.getToolTip().add(Component.m_237110_((String)"tip.bettertags.shift", (Object[])new Object[]{Component.m_237115_((String)"tip.shift").m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        if (itemStack.m_41720_() == Items.f_42718_) {
            if (((Boolean)BetterTags.CONFIGURATION.showInfoStew.get()).booleanValue() && itemStack.m_41782_() && itemStack.m_41783_().m_128425_("Effects", 9)) {
                ListTag nbtList = itemStack.m_41783_().m_128437_("Effects", 10);
                int line = 1;
                for (int i = 0; i < nbtList.size(); ++i) {
                    MobEffect statusEffect;
                    int j = 160;
                    CompoundTag nbtCompound2 = nbtList.m_128728_(i);
                    if (nbtCompound2.m_128425_("EffectDuration", 3)) {
                        j = nbtCompound2.m_128451_("EffectDuration");
                    }
                    if ((statusEffect = MobEffect.m_19453_((int)nbtCompound2.m_128445_("EffectId"))) == null) continue;
                    event.getToolTip().add(line, Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{statusEffect.m_19482_(), StringUtil.m_14404_((int)j)}).m_130940_(statusEffect.m_19483_().m_19497_()));
                    ++line;
                }
            }
        } else if (itemStack.m_41720_() == Items.f_42785_ || itemStack.m_41720_() == Items.f_42786_) {
            if (((Boolean)BetterTags.CONFIGURATION.showInfoBees.get()).booleanValue() && itemStack.m_41782_()) {
                CompoundTag nbt = itemStack.m_41783_().m_128469_("BlockEntityTag");
                ListTag nbtList = nbt.m_128437_("Bees", 10);
                if (nbtList.size() == 0) {
                    event.getToolTip().add(1, Component.m_237115_((String)"tip.bettertags.bee_empty").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(1, Component.m_237110_((String)"tip.bettertags.bees", (Object[])new Object[]{nbtList.size()}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                }
                nbt = itemStack.m_41783_().m_128469_("BlockStateTag");
                event.getToolTip().add(2, Component.m_237110_((String)"tip.bettertags.bee_level", (Object[])new Object[]{nbt.m_128461_("honey_level")}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
            }
        } else if (itemStack.m_41720_() == Items.f_42524_) {
            ClientLevel level;
            if (((Boolean)BetterTags.CONFIGURATION.showInfoClock.get()).booleanValue() && (level = Minecraft.m_91087_().f_91073_) != null) {
                event.getToolTip().add(1, Component.m_237110_((String)"tip.bettertags.clock", (Object[])new Object[]{(int)((level.m_46468_() + 6000L) / 24000L) + 1, BetterTags.getGameTime((Level)level, (Boolean)BetterTags.CONFIGURATION.isTwelves.get())}));
            }
        } else if (itemStack.m_41720_() == Items.f_220211_ && ((Boolean)BetterTags.CONFIGURATION.showInfoRecovery.get()).booleanValue() && (player = Minecraft.m_91087_().f_91074_) != null) {
            player.m_219759_().ifPresent(globalPos -> {
                event.getToolTip().add(1, Component.m_237115_((String)("biome." + globalPos.m_122640_().m_135782_().m_214298_())).m_130940_(ChatFormatting.GRAY));
                event.getToolTip().add(2, Component.m_237110_((String)"tip.coords", (Object[])new Object[]{globalPos.m_122646_().m_123341_(), globalPos.m_122646_().m_123342_(), globalPos.m_122646_().m_123343_()}).m_130940_(ChatFormatting.GRAY));
                event.getToolTip().add(3, Component.m_237110_((String)"tip.distance", (Object[])new Object[]{String.format(Locale.ROOT, "%2d", BetterTags.distanceTo(player.m_20183_(), globalPos.m_122646_()))}).m_130940_(ChatFormatting.GRAY));
            });
        }
        if (((Boolean)BetterTags.CONFIGURATION.showModName.get()).booleanValue() && (st = BetterTags.getModName(itemStack)) != null) {
            event.getToolTip().add(Component.m_237113_((String)st).m_130940_(ChatFormatting.BLUE));
        }
    }

    private static int distanceTo(BlockPos start, BlockPos end) {
        float f = start.m_123341_() - end.m_123341_();
        float f1 = start.m_123342_() - end.m_123342_();
        float f2 = start.m_123343_() - end.m_123343_();
        return (int)Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    @Nullable
    private static String getModName(ItemStack itemStack) {
        String modName = itemStack.m_41720_().getCreatorModId(itemStack);
        if (modName != null) {
            return ModList.get().getModContainerById(modName).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modName));
        }
        return null;
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        new nbtCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static int getNBTSize(@Nullable CompoundTag nbt) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130079_(nbt);
        buffer.release();
        return buffer.writerIndex();
    }

    private static <TYPE> Collection<ResourceLocation> getTags(Stream<TagKey<TYPE>> tags) {
        return tags.map(TagKey::f_203868_).collect(Collectors.toUnmodifiableSet());
    }

    private static String getTimeStringShort(int seconds) {
        int days = seconds / 86400;
        int n = seconds % 86400;
        int hours = n / 3600;
        int minutes = (n %= 3600) / 60;
        int secs = n % 60;
        String ss = days != 0 ? String.format("%02d:%02d:%02d:%02d", days, hours, minutes, secs) : (hours != 0 ? String.format("%02d:%02d:%02d", hours, minutes, secs) : String.format("%d:%02d", minutes, secs));
        return ss;
    }

    private static String getGameTime(Level level, boolean isTwelveHour) {
        double ratio = 16.666666666666668;
        int dayTime = (int)((level.m_46468_() + 6000L) % 24000L);
        int hours = dayTime / 1000;
        int minutes = (int)((double)(dayTime % 1000) / ratio);
        String post = "";
        if (isTwelveHour) {
            if (hours >= 12) {
                hours -= 12;
                post = " PM";
            } else {
                post = " AM";
            }
        }
        return (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + post;
    }
}

