/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.model;

import foundationgames.enhancedblockentities.client.model.DynamicModelEffects;
import foundationgames.enhancedblockentities.client.model.ModelSelector;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DynamicBakedModel
implements BakedModel,
FabricBakedModel {
    private final BakedModel[] models;
    private final ModelSelector selector;
    private final DynamicModelEffects effects;

    public DynamicBakedModel(BakedModel[] models, ModelSelector selector, DynamicModelEffects effects) {
        this.models = models;
        this.selector = selector;
        this.effects = effects;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(BlockAndTintGetter view, BlockState state, BlockPos blockPos, Supplier<RandomSource> rng, RenderContext context) {
        QuadEmitter emitter = context.getEmitter();
        BakedModel model = this.models[this.getSelector().getModelIndex(view, state, blockPos, rng, context)];
        RenderMaterial mat = null;
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        if (renderer != null) {
            mat = renderer.materialById(RenderMaterial.MATERIAL_STANDARD);
        }
        for (int i = 0; i <= 6; ++i) {
            Direction dir = ModelHelper.faceFromIndex((int)i);
            for (BakedQuad quad : model.m_213637_(state, dir, rng.get())) {
                emitter.fromVanilla(quad, mat, dir);
                emitter.emit();
            }
        }
    }

    public void emitItemQuads(ItemStack itemStack, Supplier<RandomSource> supplier, RenderContext renderContext) {
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        return this.models[0].m_213637_(state, face, random);
    }

    public boolean m_7541_() {
        return this.getEffects().ambientOcclusion();
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.models[0].m_6160_();
    }

    public ItemTransforms m_7442_() {
        return null;
    }

    public ItemOverrides m_7343_() {
        return null;
    }

    public BakedModel[] getModels() {
        return this.models;
    }

    public ModelSelector getSelector() {
        return this.selector;
    }

    public DynamicModelEffects getEffects() {
        return this.effects;
    }
}

