/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import foundationgames.enhancedblockentities.client.model.ModelIdentifiers;
import foundationgames.enhancedblockentities.client.render.BlockEntityRendererOverride;
import foundationgames.enhancedblockentities.util.EBEUtil;
import foundationgames.enhancedblockentities.util.duck.BakedModelManagerAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BellBlockEntityRendererOverride
extends BlockEntityRendererOverride {
    private BakedModel bellModel = null;

    @Override
    public void render(BlockEntity blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (this.bellModel == null) {
            this.bellModel = this.getBellModel();
        }
        if (blockEntity instanceof BellBlockEntity) {
            BellBlockEntity self = (BellBlockEntity)blockEntity;
            float ringTicks = (float)self.f_58813_ + tickDelta;
            float bellPitch = 0.0f;
            float bellRoll = 0.0f;
            if (self.f_58814_) {
                float swingAngle = Mth.m_14031_((float)(ringTicks / (float)Math.PI)) / (4.0f + ringTicks / 3.0f);
                if (self.f_58815_ == Direction.NORTH) {
                    bellPitch = -swingAngle;
                } else if (self.f_58815_ == Direction.SOUTH) {
                    bellPitch = swingAngle;
                } else if (self.f_58815_ == Direction.EAST) {
                    bellRoll = -swingAngle;
                } else if (self.f_58815_ == Direction.WEST) {
                    bellRoll = swingAngle;
                }
            }
            matrices.m_85836_();
            matrices.m_85837_(0.5, 0.75, 0.5);
            matrices.m_85845_(Vector3f.f_122223_.m_122270_(bellPitch));
            matrices.m_85845_(Vector3f.f_122227_.m_122270_(bellRoll));
            matrices.m_85837_(-0.5, -0.75, -0.5);
            EBEUtil.renderBakedModel(vertexConsumers, blockEntity.m_58900_(), matrices, this.bellModel, light, overlay);
            matrices.m_85849_();
        }
    }

    private BakedModel getBellModel() {
        BakedModelManagerAccess manager = (BakedModelManagerAccess)Minecraft.m_91087_().m_91304_();
        return manager.getModel(ModelIdentifiers.BELL_BODY);
    }

    @Override
    public void onModelsReload() {
        this.bellModel = null;
    }
}

