/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.model.purpoid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.endimator.Endimation;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.entity.EndimatorEntityModel;
import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class PurpoidModel
extends EndimatorEntityModel<Purpoid> {
    public static final ModelLayerLocation LOCATION = new ModelLayerLocation(new ResourceLocation("endergetic", "purpoid"), "main");
    private static final ResourceLocation REST_ONTO_FLOWER_ENDIMATION = new ResourceLocation("endergetic", "purpoid/rest_onto_flower");
    public ModelPart head;
    public ModelPart rim1;
    public ModelPart rim2;
    public ModelPart rim3;
    public ModelPart rim4;
    public ModelPart tentacleSmall1;
    public ModelPart tentacleSmall2;
    public ModelPart tentacleSmall3;
    public ModelPart tentacleSmall4;
    public ModelPart tentacleLarge1;
    public ModelPart tentacleLarge2;
    public ModelPart tentacleLarge3;
    public ModelPart tentacleLarge4;

    public PurpoidModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.rim1 = this.head.m_171324_("rim1");
        this.rim2 = this.head.m_171324_("rim2");
        this.rim3 = this.head.m_171324_("rim3");
        this.rim4 = this.head.m_171324_("rim4");
        this.tentacleSmall1 = this.head.m_171324_("tentacleSmall1");
        this.tentacleSmall2 = this.head.m_171324_("tentacleSmall2");
        this.tentacleSmall3 = this.head.m_171324_("tentacleSmall3");
        this.tentacleSmall4 = this.head.m_171324_("tentacleSmall4");
        this.tentacleLarge1 = this.head.m_171324_("tentacleLarge1");
        this.tentacleLarge2 = this.head.m_171324_("tentacleLarge2");
        this.tentacleLarge3 = this.head.m_171324_("tentacleLarge3");
        this.tentacleLarge4 = this.head.m_171324_("tentacleLarge4");
        this.endimator = Endimator.compile((ModelPart)root);
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171506_(-7.0f, -13.0f, -7.0f, 14.0f, 13.0f, 14.0f, false), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rim1 = head.m_171599_("rim1", CubeListBuilder.m_171558_().m_171514_(12, 59).m_171506_(-9.0f, 0.0f, 0.0f, 18.0f, 6.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-7.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition rim2 = head.m_171599_("rim2", CubeListBuilder.m_171558_().m_171514_(12, 59).m_171506_(-9.0f, 0.0f, 0.0f, 18.0f, 6.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)7.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition rim3 = head.m_171599_("rim3", CubeListBuilder.m_171558_().m_171514_(12, 41).m_171506_(0.0f, 0.0f, -9.0f, 0.0f, 6.0f, 18.0f, false), PartPose.m_171423_((float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f));
        PartDefinition rim4 = head.m_171599_("rim4", CubeListBuilder.m_171558_().m_171514_(12, 41).m_171506_(0.0f, 0.0f, -9.0f, 0.0f, 6.0f, 18.0f, false), PartPose.m_171423_((float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition tentacleSmall1 = head.m_171599_("tentacleSmall1", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 32.0f, 0.0f, false), PartPose.m_171423_((float)-5.5f, (float)0.0f, (float)6.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        PartDefinition tentacleSmall2 = head.m_171599_("tentacleSmall2", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 32.0f, 0.0f, false), PartPose.m_171423_((float)5.5f, (float)0.0f, (float)6.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition tentacleSmall3 = head.m_171599_("tentacleSmall3", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 32.0f, 0.0f, true), PartPose.m_171423_((float)5.5f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        PartDefinition tentacleSmall4 = head.m_171599_("tentacleSmall4", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 32.0f, 0.0f, false), PartPose.m_171423_((float)-5.5f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition tentacleLarge1 = head.m_171599_("tentacleLarge1", CubeListBuilder.m_171558_().m_171514_(6, 59).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 37.0f, 0.0f, true), PartPose.m_171423_((float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        PartDefinition tentacleLarge2 = head.m_171599_("tentacleLarge2", CubeListBuilder.m_171558_().m_171514_(6, 59).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 37.0f, 0.0f, false), PartPose.m_171423_((float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        PartDefinition tentacleLarge3 = head.m_171599_("tentacleLarge3", CubeListBuilder.m_171558_().m_171514_(6, 59).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 37.0f, 0.0f, true), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tentacleLarge4 = head.m_171599_("tentacleLarge4", CubeListBuilder.m_171558_().m_171514_(6, 59).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 37.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)96);
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(Purpoid purpoid, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_((Entity)purpoid, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.applyRestingAnimation(purpoid);
        if (purpoid.m_6162_()) {
            limbSwing /= 3.0f;
        }
        float rimAngle = 0.17f * Mth.m_14031_((float)(0.1f * ageInTicks)) + Mth.m_14089_((float)(limbSwing * 0.8f)) * limbSwingAmount * 1.16f;
        this.rim1.f_104203_ -= rimAngle;
        this.rim2.f_104203_ += rimAngle;
        this.rim3.f_104205_ -= rimAngle;
        this.rim4.f_104205_ += rimAngle;
        float tentacleAngle = (purpoid.getStunTimer() <= 0 ? 0.09f : 0.0863938f) * Mth.m_14089_((float)(0.1f * ageInTicks + 1.0f)) + Mth.m_14031_((float)(limbSwing * 0.6f)) * Math.min(0.3f, limbSwingAmount) * 0.5f;
        this.tentacleLarge1.f_104203_ -= tentacleAngle;
        this.tentacleLarge2.f_104203_ += tentacleAngle;
        this.tentacleLarge3.f_104203_ += tentacleAngle;
        this.tentacleLarge4.f_104203_ -= tentacleAngle;
        this.tentacleSmall1.f_104203_ += tentacleAngle;
        this.tentacleSmall2.f_104203_ += tentacleAngle;
        this.tentacleSmall3.f_104203_ -= tentacleAngle;
        this.tentacleSmall4.f_104203_ -= tentacleAngle;
    }

    protected void applyRestingAnimation(Purpoid purpoid) {
        float time;
        Endimation endimation = Blueprint.ENDIMATION_LOADER.getEndimation(REST_ONTO_FLOWER_ENDIMATION);
        if (endimation != null && (time = purpoid.getRestOntoAnimationProgress(ClientInfo.getPartialTicks()) * endimation.getLength()) > 0.0f) {
            this.endimator.apply(endimation, time, Endimator.ResetMode.UNAPPLY);
        }
    }

    public void reset() {
        this.endimator.getPoseMap().forEach((partName, posedPart) -> {
            posedPart.reset();
            posedPart.part.reset();
        });
    }
}

