/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.teamabnormals.endergetic.client.model.bolloom.BolloomBalloonModel;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomBalloon;
import com.teamabnormals.endergetic.core.registry.other.EERenderTypes;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public final class BolloomBalloonRenderer
extends EntityRenderer<BolloomBalloon> {
    private static final Minecraft MC = Minecraft.m_91087_();
    private final BolloomBalloonModel<BolloomBalloon> model;

    public BolloomBalloonRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new BolloomBalloonModel(context.m_174023_(BolloomBalloonModel.LOCATION));
    }

    public void render(BolloomBalloon balloon, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 1.5, 0.0);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.model.m_103119_(this.getTextureLocation(balloon)));
        this.model.setupAnim(balloon, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.model.m_7695_(matrixStack, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.model.renderString(matrixStack, bufferIn.m_6299_(EERenderTypes.BOLLOOM_STRING), packedLightIn);
        matrixStack.m_85849_();
        super.m_7392_((Entity)balloon, entityYaw, partialTicks, matrixStack, bufferIn, packedLightIn);
    }

    public boolean shouldRender(BolloomBalloon balloon, Frustum camera, double camX, double camY, double camZ) {
        if (!balloon.m_6000_(camX, camY, camZ)) {
            return false;
        }
        LocalPlayer player = BolloomBalloonRenderer.MC.f_91074_;
        return balloon.getAttachedEntity() != player || BolloomBalloonRenderer.MC.f_91066_.m_92176_() != CameraType.FIRST_PERSON || player.m_146909_() < -45.0f;
    }

    public ResourceLocation getTextureLocation(BolloomBalloon balloon) {
        return balloon.getColor().texture;
    }
}

