/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.teamabnormals.endergetic.client.model.purpoid.PurpoidGelModel;
import com.teamabnormals.endergetic.client.model.purpoid.PurpoidModel;
import com.teamabnormals.endergetic.client.renderer.entity.PurpoidRenderer;
import com.teamabnormals.endergetic.client.renderer.entity.layers.PurpoidEmissiveLayer;
import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.common.entity.purpoid.PurpoidSize;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class PurpazoidStunLayer
extends RenderLayer<Purpoid, PurpoidModel> {
    private static final Vec2[] PURP_VERTEXES = new Vec2[]{new Vec2(0.0f, -14.4f), new Vec2(-14.4f, 9.6f), new Vec2(14.4f, 9.6f)};
    private final PurpoidModel purpModel;
    private final PurpoidGelModel gelModel;

    public PurpazoidStunLayer(RenderLayerParent<Purpoid, PurpoidModel> parent, PurpoidModel purpModel, PurpoidGelModel gelModel) {
        super(parent);
        this.purpModel = purpModel;
        this.gelModel = gelModel;
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int packedLightIn, Purpoid purpoid, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float stunTimerHalfCycles = ((float)purpoid.getStunTimer() - partialTicks) / 20.0f;
        float stunTimerMultiplier = Math.min(stunTimerHalfCycles, 1.0f);
        if (stunTimerMultiplier <= 0.0f || purpoid.getSize() != PurpoidSize.PURPAZOID) {
            return;
        }
        PurpoidModel model = this.purpModel;
        model.reset();
        PurpoidGelModel gelModel = this.gelModel;
        gelModel.reset();
        gelModel.parentToHead(model.head);
        stack.m_85836_();
        stack.m_85837_(0.0, -2.75, 0.0);
        stack.m_85845_(Vector3f.f_122225_.m_122270_(0.20943952f * ageInTicks));
        ModelPart gelLayer = gelModel.gelLayer;
        ModelPart head = model.head;
        float originalHeadZ = head.f_104202_;
        float originalHeadX = head.f_104200_;
        int overlay = OverlayTexture.m_118093_((int)0, (int)10);
        float inAndOutProgress = 1.0f - 2.0f * Mth.m_14154_((float)(stunTimerHalfCycles - (float)Mth.m_14143_((float)(stunTimerHalfCycles + 0.5f))));
        float alpha = stunTimerMultiplier * (0.1f + 0.3f * (inAndOutProgress * inAndOutProgress));
        float rotation = 0.10471976f * ageInTicks;
        RenderType nonEmissiveRenderType = RenderType.m_110473_((ResourceLocation)PurpoidRenderer.getTexture(1));
        RenderType emissiveRenderType = RenderType.m_110473_((ResourceLocation)PurpoidEmissiveLayer.TEXTURES[1]);
        for (int i = 0; i < PURP_VERTEXES.length; ++i) {
            Vec2 vertex = PURP_VERTEXES[i];
            gelLayer.f_104202_ = head.f_104202_ = originalHeadZ + vertex.f_82471_;
            gelLayer.f_104200_ = head.f_104200_ = originalHeadX + vertex.f_82470_;
            gelLayer.f_104204_ = head.f_104204_ = rotation - (float)i * 2.0944f;
            VertexConsumer nonEmissiveBuffer = bufferSource.m_6299_(nonEmissiveRenderType);
            model.m_7695_(stack, nonEmissiveBuffer, 240, overlay, 1.0f, 1.0f, 1.0f, alpha);
            gelModel.m_7695_(stack, nonEmissiveBuffer, 240, overlay, 1.0f, 1.0f, 1.0f, alpha);
            gelModel.m_7695_(stack, bufferSource.m_6299_(emissiveRenderType), 240, overlay, 1.0f, 1.0f, 1.0f, alpha);
        }
        stack.m_85849_();
    }
}

