/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block;

import com.google.common.collect.Maps;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.other.EEEvents;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.FluidState;

public class CorrockBlock
extends Block
implements BonemealableBlock {
    private static final Map<ResourceLocation, Supplier<Block>> CONVERSIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), conversions -> {
        conversions.put(BuiltinDimensionTypes.f_223538_.m_135782_(), EEBlocks.CORROCK_OVERWORLD_BLOCK);
        conversions.put(BuiltinDimensionTypes.f_223539_.m_135782_(), EEBlocks.CORROCK_NETHER_BLOCK);
        conversions.put(BuiltinDimensionTypes.f_223540_.m_135782_(), EEBlocks.CORROCK_END_BLOCK);
    });
    private final Supplier<Block> speckledBlock;
    private final Supplier<Block> plantBlock;

    public CorrockBlock(BlockBehaviour.Properties properties, Supplier<Block> speckledBlock, Supplier<Block> plantBlock) {
        super(properties);
        this.speckledBlock = speckledBlock;
        this.plantBlock = plantBlock;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Block conversion = this.getConversionBlock((LevelAccessor)level);
        if (conversion != this) {
            level.m_46597_(pos, conversion.m_49966_());
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        return SoundType.f_56753_;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.shouldConvert(worldIn)) {
            worldIn.m_186460_(currentPos, (Block)this, 60 + worldIn.m_213780_().m_188503_(40));
        }
        if (CorrockBlock.isSubmerged(worldIn, currentPos)) {
            return EEEvents.convertCorrockBlock(stateIn);
        }
        return stateIn;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (this.shouldConvert((LevelAccessor)context.m_43725_())) {
            context.m_43725_().m_186460_(context.m_8083_(), (Block)this, 60 + context.m_43725_().m_213780_().m_188503_(40));
        }
        return this.m_49966_();
    }

    protected Block getConversionBlock(LevelAccessor level) {
        return (Block)((Supplier)CONVERSIONS.getOrDefault(((Registry)level.m_5962_().m_6632_(Registry.f_122818_).get()).m_7981_((Object)level.m_6042_()), (Supplier<Block>)EEBlocks.CORROCK_OVERWORLD_BLOCK)).get();
    }

    protected boolean shouldConvert(LevelAccessor level) {
        return this.getConversionBlock(level) != this;
    }

    public static boolean isSubmerged(LevelAccessor world, BlockPos pos) {
        for (Direction offsets : Direction.values()) {
            FluidState fluidState = world.m_6425_(pos.m_121945_(offsets));
            if (fluidState.m_76178_() || !fluidState.m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return entityType == EEEntityTypes.CHARGER_EETLE.get() || super.isValidSpawn(state, level, pos, type, entityType);
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level p_220878_, RandomSource p_220879_, BlockPos p_220880_, BlockState p_220881_) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        int radius = 2;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Block speckledBlock = this.speckledBlock.get();
        BlockState speckledState = speckledBlock.m_49966_();
        BlockState plantState = this.plantBlock.get().m_49966_();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                boolean isSpeckled;
                mutable.m_122154_((Vec3i)pos, x, 0, z);
                Block block = this.findHighestSpreadableBlock(level, mutable, speckledBlock);
                boolean thisBlock = block == this;
                boolean bl = isSpeckled = block == speckledBlock;
                if (block != Blocks.f_50259_ && !thisBlock && !isSpeckled) continue;
                int distanceSq = x * x + z * z - rand.m_188503_(2);
                if (distanceSq <= 1) {
                    this.placeSpreadBlock(level, (BlockPos)mutable, this.m_49966_(), plantState, rand, false);
                    continue;
                }
                if (distanceSq > 4) continue;
                boolean notSpeckled = isSpeckled || thisBlock;
                this.placeSpreadBlock(level, (BlockPos)mutable, notSpeckled ? this.m_49966_() : speckledState, plantState, rand, !notSpeckled);
            }
        }
    }

    private void placeSpreadBlock(ServerLevel world, BlockPos pos, BlockState state, BlockState plantState, RandomSource random, boolean speckled) {
        BlockPos up;
        world.m_46597_(pos, state);
        float f = random.m_188501_();
        float f2 = speckled ? 0.1f : 0.2f;
        if (f < f2 && world.m_46859_(up = pos.m_7494_())) {
            world.m_46597_(up, plantState);
        }
    }

    @Nullable
    private Block findHighestSpreadableBlock(ServerLevel world, BlockPos.MutableBlockPos mutable, Block speckledBlock) {
        int originY = mutable.m_123342_();
        for (int y = 1; y > -2; --y) {
            mutable.m_142448_(originY + y);
            Block block = world.m_8055_((BlockPos)mutable).m_60734_();
            if (block != Blocks.f_50259_ && block != this && block != speckledBlock) continue;
            return block;
        }
        return null;
    }
}

