/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block;

import com.google.common.collect.Maps;
import com.teamabnormals.endergetic.client.particle.data.CorrockCrownParticleData;
import com.teamabnormals.endergetic.common.block.CorrockCrownBlock;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.other.EEEvents;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CorrockCrownStandingBlock
extends CorrockCrownBlock {
    private static final Map<ResourceLocation, Supplier<CorrockCrownBlock>> CONVERSIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), conversions -> {
        conversions.put(BuiltinDimensionTypes.f_223538_.m_135782_(), EEBlocks.CORROCK_CROWN_OVERWORLD_STANDING);
        conversions.put(BuiltinDimensionTypes.f_223539_.m_135782_(), EEBlocks.CORROCK_CROWN_NETHER_STANDING);
        conversions.put(BuiltinDimensionTypes.f_223540_.m_135782_(), EEBlocks.CORROCK_CROWN_END_STANDING);
    });
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.m_61465_((String)"upside_down");

    public CorrockCrownStandingBlock(BlockBehaviour.Properties properties, CorrockCrownBlock.DimensionalType dimensionalType, boolean petrified) {
        super(properties, dimensionalType, petrified);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0) : Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)UPSIDE_DOWN)).booleanValue()) {
            double xOffset = CorrockCrownStandingBlock.makeNegativeRandomly(rand.m_188501_() * 0.35f, rand);
            double yOffset = CorrockCrownStandingBlock.makeNegativeRandomly(rand.m_188501_() * 0.35f, rand);
            double zOffset = CorrockCrownStandingBlock.makeNegativeRandomly(rand.m_188501_() * 0.35f, rand);
            double posX = (double)pos.m_123341_() + 0.5 + xOffset;
            double posY = (double)pos.m_123342_() + 0.5 + yOffset;
            double posZ = (double)pos.m_123343_() + 0.5 + zOffset;
            world.m_7106_((ParticleOptions)new CorrockCrownParticleData(this.dimensionalType.particle.get(), false), posX, posY, posZ, (double)(rand.m_188501_() * 0.05f - rand.m_188501_() * 0.05f), (double)-0.005f, (double)(rand.m_188501_() * 0.05f - rand.m_188501_() * 0.05f));
        } else if (rand.m_188501_() < 0.6f) {
            double xOffset = CorrockCrownStandingBlock.makeNegativeRandomly(rand.m_188501_() * 0.25f, rand);
            double yOffset = CorrockCrownStandingBlock.makeNegativeRandomly(rand.m_188501_() * 0.25f, rand);
            double zOffset = CorrockCrownStandingBlock.makeNegativeRandomly(rand.m_188501_() * 0.25f, rand);
            double posX = (double)pos.m_123341_() + 0.5 + xOffset;
            double posY = (double)pos.m_123342_() + 0.5 + yOffset;
            double posZ = (double)pos.m_123343_() + 0.5 + zOffset;
            world.m_7106_((ParticleOptions)new CorrockCrownParticleData(this.dimensionalType.particle.get(), false), posX, posY, posZ, (double)(rand.m_188501_() * 0.03f - rand.m_188501_() * 0.03f), (double)(0.01f + rand.m_188501_() * 0.02f), (double)(rand.m_188501_() * 0.03f - rand.m_188501_() * 0.03f));
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.shouldConvert((LevelAccessor)level)) {
            level.m_46597_(pos, (BlockState)((BlockState)this.getConversionBlock((LevelAccessor)level).m_49966_().m_61124_((Property)ROTATION, (Comparable)((Integer)level.m_8055_(pos).m_61143_((Property)ROTATION)))).m_61124_((Property)UPSIDE_DOWN, (Comparable)((Boolean)level.m_8055_(pos).m_61143_((Property)UPSIDE_DOWN))));
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? worldIn.m_8055_(pos.m_7494_()).m_60783_((BlockGetter)worldIn, pos.m_7494_(), Direction.DOWN) : worldIn.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)worldIn, pos.m_7495_(), Direction.UP);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
            if (!this.petrified) {
                return EEEvents.convertCorrockBlock(stateIn);
            }
        }
        if (this.shouldConvert(worldIn)) {
            worldIn.m_186460_(currentPos, (Block)this, 60 + worldIn.m_213780_().m_188503_(40));
        }
        return this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? stateIn : Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        Direction direction = context.m_43719_();
        if (this.shouldConvert((LevelAccessor)context.m_43725_())) {
            context.m_43725_().m_186460_(context.m_8083_(), (Block)this, 60 + context.m_43725_().m_213780_().m_188503_(40));
        }
        if (context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_60734_() instanceof CorrockCrownStandingBlock) {
            return null;
        }
        return direction == Direction.UP ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(Mth.m_14107_((double)((double)((180.0f + context.m_7074_()) * 16.0f / 360.0f) + 0.5)) & 0xF))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_205070_(FluidTags.f_13131_) && ifluidstate.m_76186_() >= 8)) : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(Mth.m_14107_((double)((double)((180.0f + context.m_7074_()) * 16.0f / 360.0f) + 0.5)) & 0xF))).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_205070_(FluidTags.f_13131_) && ifluidstate.m_76186_() >= 8));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rot.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirrorIn.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ROTATION, WATERLOGGED, UPSIDE_DOWN});
    }

    protected Block getConversionBlock(LevelAccessor level) {
        return (Block)((Supplier)CONVERSIONS.getOrDefault(((Registry)level.m_5962_().m_6632_(Registry.f_122818_).get()).m_7981_((Object)level.m_6042_()), (Supplier<CorrockCrownBlock>)EEBlocks.CORROCK_CROWN_OVERWORLD_STANDING)).get();
    }

    private boolean shouldConvert(LevelAccessor level) {
        return !this.petrified && this.getConversionBlock(level) != this;
    }

    private static double makeNegativeRandomly(double value, RandomSource rand) {
        return rand.m_188499_() ? -value : value;
    }

    public ItemStack m_142598_(LevelAccessor p_152719_, BlockPos p_152720_, BlockState p_152721_) {
        return new ItemStack((ItemLike)this);
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.empty();
    }
}

