/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.bolloom;

import com.teamabnormals.endergetic.core.registry.EEBlocks;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractBolloom
extends Entity {
    private static final EntityDataAccessor<Float> ORIGIN_X = SynchedEntityData.m_135353_(AbstractBolloom.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ORIGIN_Y = SynchedEntityData.m_135353_(AbstractBolloom.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ORIGIN_Z = SynchedEntityData.m_135353_(AbstractBolloom.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> VINE_Y_ROT = SynchedEntityData.m_135353_(AbstractBolloom.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DESIRED_VINE_Y_ROT = SynchedEntityData.m_135353_(AbstractBolloom.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> TICKS_EXISTED = SynchedEntityData.m_135353_(AbstractBolloom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> UNTIED = SynchedEntityData.m_135353_(AbstractBolloom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float sway;
    private float prevVineXRot;
    private float prevVineYRot;

    protected AbstractBolloom(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ORIGIN_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ORIGIN_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ORIGIN_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(VINE_Y_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DESIRED_VINE_Y_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(UNTIED, (Object)false);
        this.f_19804_.m_135372_(TICKS_EXISTED, (Object)0);
    }

    public void m_8119_() {
        boolean isOnServerSide;
        float vineYRot;
        this.f_19790_ = this.f_19854_ = this.m_20185_();
        this.f_19791_ = this.f_19855_ = this.m_20186_();
        this.f_19792_ = this.f_19856_ = this.m_20189_();
        this.prevVineXRot = this.getVineXRot();
        this.prevVineYRot = vineYRot = this.getVineYRot();
        this.sway = Mth.m_14031_((float)((float)(0.06283185307179587 * (double)this.getTicksExisted()))) * 0.5f;
        this.updatePositionAndMotion(Mth.m_14031_((float)(-vineYRot)), Mth.m_14089_((float)(-vineYRot)));
        float seekingVineYRot = this.getDesiredVineYRot() - vineYRot;
        while ((double)seekingVineYRot > Math.PI) {
            seekingVineYRot = (float)((double)seekingVineYRot - Math.PI * 2);
        }
        while ((double)seekingVineYRot <= -Math.PI) {
            seekingVineYRot = (float)((double)seekingVineYRot + Math.PI * 2);
        }
        boolean bl = isOnServerSide = !this.f_19853_.f_46443_;
        if (Math.abs(seekingVineYRot) <= 0.1f) {
            this.setVineYRot(vineYRot + seekingVineYRot, isOnServerSide);
        } else if (seekingVineYRot > 0.0f) {
            this.setVineYRot(vineYRot + 0.03f, isOnServerSide);
        } else {
            this.setVineYRot(vineYRot - 0.03f, isOnServerSide);
        }
        if (isOnServerSide) {
            if (this.m_20186_() >= 254.0 && this.isUntied()) {
                this.onBroken(true);
                this.m_146870_();
            }
            if (this.getTicksExisted() % 50 == 0) {
                this.setDesiredVineYRot((float)(this.f_19796_.m_188500_() * 2.0 * Math.PI));
            }
            this.updateUntied();
        }
        if (this.shouldIncrementTicksExisted()) {
            this.incrementTicksExisted(isOnServerSide);
        }
        this.m_20095_();
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("Untied", this.isUntied());
        compound.m_128350_("OriginX", this.getOriginX());
        compound.m_128350_("OriginY", this.getOriginY());
        compound.m_128350_("OriginZ", this.getOriginZ());
    }

    protected void m_7378_(CompoundTag compound) {
        this.setUntied(compound.m_128471_("Untied"));
        if (compound.m_128425_("OriginX", 5) && compound.m_128425_("OriginY", 5) && compound.m_128425_("OriginZ", 5)) {
            this.setOrigin(compound.m_128457_("OriginX"), compound.m_128457_("OriginY"), compound.m_128457_("OriginZ"));
        } else {
            this.setUntied(true);
        }
    }

    public void setOrigin(float x, float y, float z) {
        this.f_19804_.m_135381_(ORIGIN_X, (Object)Float.valueOf(x));
        this.f_19804_.m_135381_(ORIGIN_Y, (Object)Float.valueOf(y));
        this.f_19804_.m_135381_(ORIGIN_Z, (Object)Float.valueOf(z));
    }

    public float getOriginX() {
        return ((Float)this.f_19804_.m_135370_(ORIGIN_X)).floatValue();
    }

    public float getOriginY() {
        return ((Float)this.f_19804_.m_135370_(ORIGIN_Y)).floatValue();
    }

    public float getOriginZ() {
        return ((Float)this.f_19804_.m_135370_(ORIGIN_Z)).floatValue();
    }

    public void setVineYRot(float radians, boolean updateClient) {
        SynchedEntityData.DataItem dataItem = this.f_19804_.m_135379_(VINE_Y_ROT);
        if (ObjectUtils.notEqual((Object)Float.valueOf(radians), (Object)dataItem.m_135403_())) {
            dataItem.m_135397_((Object)Float.valueOf(radians));
            this.m_7350_(VINE_Y_ROT);
            if (updateClient) {
                dataItem.m_135401_(true);
            }
        }
    }

    public float getVineYRot() {
        return ((Float)this.f_19804_.m_135370_(VINE_Y_ROT)).floatValue();
    }

    public void setDesiredVineYRot(float radians) {
        this.f_19804_.m_135381_(DESIRED_VINE_Y_ROT, (Object)Float.valueOf(radians));
    }

    public float getDesiredVineYRot() {
        return ((Float)this.f_19804_.m_135370_(DESIRED_VINE_Y_ROT)).floatValue();
    }

    public float getVineXRot() {
        return (float)Math.atan(this.getSway() / 2.0f);
    }

    public float getSway() {
        return this.sway;
    }

    public void setUntied(boolean untied) {
        this.f_19804_.m_135381_(UNTIED, (Object)untied);
    }

    public boolean isUntied() {
        return (Boolean)this.f_19804_.m_135370_(UNTIED);
    }

    public void incrementTicksExisted(boolean updateClient) {
        int ticksExisted = (Integer)this.f_19804_.m_135370_(TICKS_EXISTED) + 1;
        SynchedEntityData.DataItem dataItem = this.f_19804_.m_135379_(TICKS_EXISTED);
        if (ObjectUtils.notEqual((Object)ticksExisted, (Object)dataItem.m_135403_())) {
            dataItem.m_135397_((Object)ticksExisted);
            this.m_7350_(TICKS_EXISTED);
            if (updateClient) {
                dataItem.m_135401_(true);
            }
        }
    }

    public int getTicksExisted() {
        return (Integer)this.f_19804_.m_135370_(TICKS_EXISTED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float[] getVineAnimation(float partialTicks) {
        return new float[]{Mth.m_14179_((float)partialTicks, (float)this.prevVineXRot, (float)this.getVineXRot()), Mth.m_14179_((float)partialTicks, (float)this.prevVineYRot, (float)this.getVineYRot())};
    }

    public abstract void updatePositionAndMotion(double var1, double var3);

    public abstract void updateUntied();

    public boolean shouldIncrementTicksExisted() {
        return true;
    }

    public void onBroken(boolean dropFruit) {
        this.m_5496_(SoundEvents.f_12543_, 1.0f, 1.0f);
        this.doParticles();
    }

    protected void doParticles() {
        if (this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)EEBlocks.BOLLOOM_PARTICLE.get()).m_49966_()), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 1.5, this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return this.m_6084_();
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return this.m_20147_() && source != DamageSource.f_19317_ && source != DamageSource.f_19311_;
    }

    protected Vec3 m_20133_(Vec3 pos) {
        return Vec3.f_82478_;
    }

    public boolean m_7313_(Entity entityIn) {
        return entityIn instanceof Player && this.m_6469_(DamageSource.m_19344_((Player)((Player)entityIn)), 0.0f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            this.m_146870_();
            this.m_5834_();
            this.onBroken(true);
        }
        return true;
    }

    public void m_5997_(double x, double y, double z) {
        if (!this.isUntied()) {
            return;
        }
        super.m_5997_(x, y, z);
    }

    public AABB m_6921_() {
        return super.m_6921_().m_82400_(5.0);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

