/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.booflo.ai;

import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.Path;

public class BoofloAttackGoal
extends Goal {
    private final int UPPER_DISTANCE = 16;
    private final Booflo booflo;
    private Path path;
    private BlockPos upperAirPos;
    private int delayCounter;

    public BoofloAttackGoal(Booflo booflo) {
        this.booflo = booflo;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (!this.booflo.hasAggressiveAttackTarget()) {
            return false;
        }
        if (!this.booflo.isBoofed()) {
            return false;
        }
        if (this.booflo.getBoofloAttackTarget() instanceof PuffBug) {
            return false;
        }
        this.upperAirPos = this.getUpperPosToTarget(target);
        if (this.upperAirPos == null) {
            Path newPath = this.booflo.m_21573_().m_6570_(target, 0);
            this.upperAirPos = newPath != null ? newPath.m_77406_() : null;
            return this.upperAirPos != null;
        }
        this.path = this.booflo.m_21573_().m_7864_(this.upperAirPos, 0);
        return this.path != null && this.booflo.hasAggressiveAttackTarget();
    }

    public boolean m_8045_() {
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (!this.booflo.isBoofed()) {
            return false;
        }
        if (this.booflo.m_20183_().m_123331_((Vec3i)this.upperAirPos) > 16.0) {
            return false;
        }
        return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
    }

    public void m_8056_() {
        this.booflo.m_21573_().m_26536_(this.path, (double)1.35f);
        this.booflo.m_21561_(true);
        this.delayCounter = 0;
    }

    public void m_8041_() {
        Entity target = this.booflo.getBoofloAttackTarget();
        if (!EntitySelector.f_20406_.test(target)) {
            this.booflo.setBoofloAttackTargetId(0);
        }
        this.booflo.m_21561_(false);
        this.booflo.m_21573_().m_26573_();
    }

    public void m_8037_() {
        --this.delayCounter;
        Entity target = this.booflo.getBoofloAttackTarget();
        if (target != null && this.upperAirPos != null) {
            this.booflo.m_21563_().m_24950_((double)this.upperAirPos.m_123341_(), (double)this.upperAirPos.m_123342_(), (double)this.upperAirPos.m_123343_(), 10.0f, 10.0f);
            double distToEnemySqr = this.booflo.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
            if (this.delayCounter <= 0 && !target.m_20145_()) {
                this.delayCounter = 4 + this.booflo.m_217043_().m_188503_(7);
                if (distToEnemySqr > 256.0) {
                    this.delayCounter += 5;
                }
                if (this.path != null && !this.booflo.m_21573_().m_26519_((double)this.path.m_77406_().m_123341_(), (double)this.path.m_77406_().m_123342_(), (double)this.path.m_77406_().m_123343_(), (double)1.35f)) {
                    this.delayCounter += 5;
                }
            }
        }
    }

    @Nullable
    private BlockPos getUpperPosToTarget(Entity target) {
        BlockPos startingPos = target.m_20183_();
        BlockPos targetPos = BlockPos.f_121853_;
        boolean isOpenBelow = true;
        for (int y = 0; y < 16; ++y) {
            if (!target.f_19853_.m_8055_(startingPos.m_6630_(y)).m_60812_((BlockGetter)target.f_19853_, startingPos.m_6630_(y)).m_83281_()) {
                isOpenBelow = false;
            }
            if (!target.f_19853_.m_8055_(startingPos.m_6630_(y)).m_60812_((BlockGetter)target.f_19853_, startingPos.m_6630_(y)).m_83281_() || y <= 9) continue;
            targetPos = startingPos.m_6630_(y);
        }
        return isOpenBelow ? targetPos : null;
    }

    public boolean m_183429_() {
        return true;
    }
}

