/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.booflo.ai;

import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.common.advancement.EECriteriaTriggers;
import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.core.registry.other.EEPlayableEndimations;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class BoofloBreedGoal
extends Goal {
    private static final TargetingConditions MATE_CHECKER = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_();
    protected final Booflo booflo;
    protected Booflo mate;
    private int impregnateDelay;

    public BoofloBreedGoal(Booflo booflo) {
        this.booflo = booflo;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.booflo.isBoofed() || !this.booflo.m_20096_() && this.booflo.m_20202_() == null || !this.booflo.isInLove() || this.booflo.isPregnant()) {
            return false;
        }
        this.mate = this.getNearbyMate();
        return this.mate != null && !this.mate.isPregnant();
    }

    public boolean m_8045_() {
        return !this.booflo.isBoofed() && this.mate.m_6084_() && this.mate.isInLove() && this.impregnateDelay < 100;
    }

    public void m_8041_() {
        this.mate = null;
        this.impregnateDelay = 0;
    }

    public void m_8037_() {
        if (this.booflo.hopDelay == 0 && this.booflo.isNoEndimationPlaying() && !this.isBeingRidenOrRiding()) {
            NetworkUtil.setPlayingAnimation((Entity)this.booflo, (PlayableEndimation)EEPlayableEndimations.BOOFLO_HOP);
        }
        if (this.booflo.m_21566_() instanceof Booflo.GroundMoveHelperController && !this.isBeingRidenOrRiding()) {
            ((Booflo.GroundMoveHelperController)this.booflo.m_21566_()).setSpeed(0.1);
        }
        double dx = this.mate.m_20185_() - this.booflo.m_20185_();
        double dz = this.mate.m_20189_() - this.booflo.m_20189_();
        float angle = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        if (this.booflo.m_21566_() instanceof Booflo.GroundMoveHelperController && !this.isBeingRidenOrRiding()) {
            ((Booflo.GroundMoveHelperController)this.booflo.m_21566_()).setDirection(angle, false);
        }
        this.booflo.m_21573_().m_5624_((Entity)this.mate, 1.0);
        ++this.impregnateDelay;
        if (this.impregnateDelay >= 60 && this.booflo.m_20280_((Entity)this.mate) < 10.0) {
            this.impregnateBooflo();
        }
    }

    protected void impregnateBooflo() {
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this.booflo, (Mob)this.mate, null);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        if (cancelled) {
            this.booflo.resetInLove();
            this.mate.resetInLove();
            return;
        }
        ServerPlayer serverplayerentity = this.booflo.getLoveCause();
        if (serverplayerentity == null && this.mate.getLoveCause() != null) {
            serverplayerentity = this.mate.getLoveCause();
        }
        if (serverplayerentity != null) {
            serverplayerentity.m_36220_(Stats.f_12937_);
            EECriteriaTriggers.BRED_BOOFLO.trigger(serverplayerentity);
        }
        if (!this.mate.isPregnant()) {
            this.booflo.babiesToBirth = 3;
        }
        this.booflo.resetInLove();
        this.mate.resetInLove();
        this.booflo.breedDelay = 1400;
        this.mate.breedDelay = 1400;
        this.booflo.f_19853_.m_7605_((Entity)this.booflo, (byte)18);
        if (this.booflo.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            this.booflo.f_19853_.m_7967_((Entity)new ExperienceOrb(this.booflo.f_19853_, this.booflo.m_20185_(), this.booflo.m_20186_(), this.booflo.m_20189_(), this.booflo.m_217043_().m_188503_(7) + 1));
        }
    }

    @Nullable
    private Booflo getNearbyMate() {
        List list = this.booflo.f_19853_.m_45971_(Booflo.class, MATE_CHECKER, (LivingEntity)this.booflo, this.booflo.m_20191_().m_82400_(16.0));
        double d0 = Double.MAX_VALUE;
        Booflo booflo = null;
        for (Booflo booflos : list) {
            if (!this.booflo.canMateWith(booflos) || !(this.booflo.m_20280_((Entity)booflos) < d0)) continue;
            booflo = booflos;
            d0 = this.booflo.m_20280_((Entity)booflos);
        }
        return booflo;
    }

    private boolean isBeingRidenOrRiding() {
        return this.booflo.m_20159_() || this.booflo.m_20160_();
    }

    public boolean m_183429_() {
        return true;
    }
}

