/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle;

import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.client.particle.data.CorrockCrownParticleData;
import com.teamabnormals.endergetic.common.block.EetleEggBlock;
import com.teamabnormals.endergetic.common.block.entity.EetleEggTileEntity;
import com.teamabnormals.endergetic.common.entity.eetle.ai.EetleHurtByTargetGoal;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEParticleTypes;
import com.teamabnormals.endergetic.core.registry.EESoundEvents;
import com.teamabnormals.endergetic.core.registry.other.EEPlayableEndimations;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractEetle
extends Monster
implements Endimatable {
    private static final EntityDataAccessor<Boolean> CHILD = SynchedEntityData.m_135353_(AbstractEetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDimensions LEETLE_SIZE = EntityDimensions.m_20398_((float)0.6f, (float)0.4375f);
    private static final AttributeModifier LEETLE_HEALTH = new AttributeModifier(UUID.fromString("8a1ea466-4b2d-11eb-ae93-0242ac130002"), "Leetle health decrease", (double)-0.8f, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final Direction[] EGG_DIRECTIONS = Direction.values();
    private final AvoidEntityGoal<Player> avoidEntityGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 12.0f, 1.0, 1.0);
    private NearestAttackableTargetGoal<Player> attackableTargetGoal;
    private int growingAge;
    private int despawnTimer;
    private boolean fromEgg;
    protected int idleDelay;

    protected AbstractEetle(EntityType<? extends AbstractEetle> type, Level world) {
        super(type, world);
        this.f_21342_ = new GroundEetleMoveController((Mob)this);
        this.f_19793_ = 0.5f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHILD, (Object)false);
    }

    protected void m_8099_() {
        this.attackableTargetGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.f_21346_.m_25352_(2, this.attackableTargetGoal);
        this.f_21346_.m_25352_(1, (Goal)new EetleHurtByTargetGoal(this));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (CHILD.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            int age = this.growingAge;
            if (age < 0) {
                this.updateAge(++age);
            } else if (age > 0) {
                this.updateAge(--age);
            }
            if (!this.m_6162_()) {
                if (this.idleDelay > 0) {
                    --this.idleDelay;
                }
                if (this.despawnTimer > 0) {
                    LivingEntity attackTarget;
                    int newTime;
                    if ((newTime = --this.despawnTimer) == 0) {
                        this.f_19853_.m_7605_((Entity)this, (byte)20);
                        this.m_146870_();
                    } else if (newTime <= 100 && newTime % 10 == 0 && (attackTarget = this.m_5448_()) != null && attackTarget.m_6084_() && this.m_20280_((Entity)attackTarget) <= 256.0 && this.m_142582_((Entity)attackTarget)) {
                        this.despawnTimer += 105 + this.f_19796_.m_188503_(11);
                    }
                }
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Age", this.growingAge);
        compound.m_128405_("DespawnTimer", this.despawnTimer);
        compound.m_128379_("FromEgg", this.fromEgg);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.updateAge(compound.m_128451_("Age"));
        this.despawnTimer = Math.max(0, compound.m_128451_("DespawnTimer"));
        this.fromEgg = compound.m_128471_("FromEgg");
    }

    public boolean m_6162_() {
        return (Boolean)this.f_19804_.m_135370_(CHILD);
    }

    public void m_6863_(boolean child) {
        boolean wasChild = this.m_6162_();
        this.f_19804_.m_135381_(CHILD, (Object)child);
        this.updateGoals(this.f_21345_, this.f_21346_, child);
        if (child) {
            AttributeInstance maxHealth;
            this.f_21364_ = 2;
            if (this.f_19853_ != null && !this.f_19853_.f_46443_ && (maxHealth = this.m_21051_(Attributes.f_22276_)) != null) {
                maxHealth.m_22118_(LEETLE_HEALTH);
                this.m_21153_(Math.max(this.m_21223_(), this.m_21233_()));
            }
        } else {
            this.f_21364_ = 6;
            if (wasChild) {
                AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
                if (maxHealth != null) {
                    maxHealth.m_22130_(LEETLE_HEALTH);
                }
                this.m_21153_(Math.min(this.m_21233_(), this.m_21223_() * 4.3f));
            }
        }
    }

    public void updateAge(int growingAge) {
        int prevAge = this.growingAge;
        this.growingAge = growingAge;
        if (prevAge < 0 && growingAge >= 0 || prevAge >= 0 && growingAge < 0) {
            boolean willBeAdult;
            boolean bl = willBeAdult = growingAge >= 0;
            if (willBeAdult && this.m_6162_()) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)EEPlayableEndimations.EETLE_GROW_UP);
                return;
            }
            if (this.isEndimationPlaying(EEPlayableEndimations.EETLE_GROW_UP) && !willBeAdult) {
                NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)PlayableEndimation.BLANK);
            }
            this.m_6863_(!willBeAdult);
        }
    }

    public int getGrowingAge() {
        return this.growingAge;
    }

    public void markFromEgg() {
        this.fromEgg = true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.NATURAL && this.f_19796_.m_188501_() < 0.4f) {
            this.updateAge(-(20000 + this.f_19796_.m_188503_(4001)));
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            int startX = (int)this.m_20185_();
            int startZ = (int)this.m_20189_();
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    EntityType type;
                    Entity entity;
                    if (!(this.f_19796_.m_188501_() < 0.1f)) continue;
                    int currentX = startX + x;
                    int currentZ = startZ + z;
                    mutable.m_122178_(currentX, world.m_6924_(Heightmap.Types.MOTION_BLOCKING, currentX, currentZ), currentZ);
                    if (!world.m_46859_((BlockPos)mutable) || !Block.m_49936_((BlockGetter)world, (BlockPos)mutable.m_7495_()) || !((entity = (type = this.m_6095_()).m_20615_(this.f_19853_)) instanceof AbstractEetle)) continue;
                    AbstractEetle eetle = (AbstractEetle)entity;
                    eetle.updateAge(-(20000 + this.f_19796_.m_188503_(4001)));
                    if (!this.f_19853_.m_7967_((Entity)eetle)) continue;
                    entity.m_19890_((double)((float)currentX + 0.5f), (double)mutable.m_123342_(), (double)((float)currentZ + 0.5f), this.f_19796_.m_188501_() * 360.0f, 0.0f);
                }
            }
        }
        return super.m_6518_(world, difficultyIn, reason, spawnData, dataTag);
    }

    public void m_6667_(DamageSource cause) {
        BlockPos pos;
        Level world = this.f_19853_;
        if (!this.m_6162_() && this.f_19796_.m_188501_() < AbstractEetle.calculateEggChance(world, this.m_20191_().m_82400_(this.m_21133_(Attributes.f_22277_) * 1.25)) && !this.m_213877_() && !this.f_20890_ && !world.f_46443_ && world.m_6425_(pos = this.m_20183_()).m_76178_() && world.m_8055_(pos).m_60767_().m_76336_()) {
            RandomSource random = this.f_19796_;
            EetleEggBlock.shuffleDirections(EGG_DIRECTIONS, random);
            BlockState defaultState = ((Block)EEBlocks.EETLE_EGG.get()).m_49966_();
            for (Direction direction : EGG_DIRECTIONS) {
                BlockState state = (BlockState)defaultState.m_61124_((Property)EetleEggBlock.FACING, (Comparable)direction);
                if (!state.m_60710_((LevelReader)world, pos)) continue;
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)EetleEggBlock.SIZE, (Comparable)Integer.valueOf(random.m_188503_(2))));
                world.m_5594_(null, pos, (SoundEvent)EESoundEvents.EETLE_EGG_PLACE.get(), SoundSource.BLOCKS, 1.0f - random.m_188501_() * 0.1f, 0.8f + random.m_188501_() * 0.2f);
                BlockEntity tileEntity = world.m_7702_(pos);
                if (tileEntity instanceof EetleEggTileEntity) {
                    EetleEggTileEntity eetleEggTileEntity = (EetleEggTileEntity)tileEntity;
                    eetleEggTileEntity.updateHatchDelay(world, random.m_188503_(11) + 5);
                    eetleEggTileEntity.bypassSpawningGameRule();
                }
                if (!(world instanceof ServerLevel)) continue;
                ((ServerLevel)world).m_8767_((ParticleOptions)new CorrockCrownParticleData((ParticleType<CorrockCrownParticleData>)((ParticleType)EEParticleTypes.END_CROWN.get()), true), this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 5, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.1);
            }
        }
        super.m_6667_(cause);
    }

    protected void updateGoals(GoalSelector goalSelector, GoalSelector targetSelector, boolean child) {
        if (child) {
            goalSelector.m_25352_(1, this.avoidEntityGoal);
            targetSelector.m_25363_(this.attackableTargetGoal);
        } else {
            goalSelector.m_25363_(this.avoidEntityGoal);
            targetSelector.m_25352_(2, this.attackableTargetGoal);
        }
    }

    public void resetIdleFlapDelay() {
        this.idleDelay = this.f_19796_.m_188503_(41) + 30;
    }

    public void applyDespawnTimer() {
        this.despawnTimer = this.f_19796_.m_188503_(101) + 600;
    }

    public void onEndimationEnd(PlayableEndimation endimation, PlayableEndimation newEndimation) {
        Level world = this.f_19853_;
        if (endimation == EEPlayableEndimations.EETLE_GROW_UP && world instanceof ServerLevel) {
            this.m_6863_(false);
            this.m_5496_((SoundEvent)EESoundEvents.LEETLE_TRANSFORM.get(), this.m_6121_(), this.m_6100_());
            ((ServerLevel)world).m_8767_((ParticleOptions)new CorrockCrownParticleData((ParticleType<CorrockCrownParticleData>)((ParticleType)EEParticleTypes.END_CROWN.get()), true), this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 5, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.1);
        }
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.m_6162_() ? LEETLE_SIZE : super.m_6972_(poseIn);
    }

    public int m_8100_() {
        return 160;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_6162_() ? (SoundEvent)EESoundEvents.LEETLE_AMBIENT.get() : super.m_7515_();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return this.m_6162_() ? (SoundEvent)EESoundEvents.LEETLE_HURT.get() : super.m_7975_(damageSourceIn);
    }

    protected SoundEvent m_5592_() {
        return this.m_6162_() ? (SoundEvent)EESoundEvents.LEETLE_DEATH.get() : super.m_5592_();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (this.m_6162_()) {
            this.m_5496_((SoundEvent)EESoundEvents.LEETLE_STEP.get(), 0.15f, 1.0f);
        } else {
            super.m_7355_(pos, blockIn);
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.65f;
    }

    public boolean m_6126_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public int m_5792_() {
        return 3;
    }

    protected boolean m_6125_() {
        return !this.m_6162_();
    }

    public ItemStack getPickedResult(HitResult target) {
        return super.getPickedResult(target);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    private static float calculateEggChance(Level world, AABB boundingBox) {
        return 0.6f - 0.075f * (float)world.m_6443_(AbstractEetle.class, boundingBox, eetle -> eetle.m_6084_() && !eetle.m_6162_()).size();
    }

    protected static class GroundEetleMoveController
    extends MoveControl {
        protected GroundEetleMoveController(Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                AbstractEetle abstractEetle;
                Mob mob = this.f_24974_;
                this.f_24981_ = MoveControl.Operation.WAIT;
                double d0 = this.f_24975_ - mob.m_20185_();
                double d1 = this.f_24977_ - mob.m_20189_();
                double d2 = this.f_24976_ - mob.m_20186_();
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.5000003E-7) {
                    mob.m_21564_(0.0f);
                    return;
                }
                float f9 = (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                mob.m_146922_(this.m_24991_(mob.m_146908_(), f9, 90.0f));
                float moveSpeed = (float)(this.f_24978_ * mob.m_21133_(Attributes.f_22279_));
                if (mob instanceof AbstractEetle && (abstractEetle = (AbstractEetle)mob).m_6162_() && abstractEetle.fromEgg) {
                    int growingAge = Math.abs(abstractEetle.growingAge);
                    moveSpeed *= Math.min(2.0f, 7.0f * (float)growingAge / ((float)growingAge + 300.0f));
                }
                mob.m_7910_(moveSpeed);
                BlockPos blockpos = mob.m_20183_();
                BlockState blockstate = mob.f_19853_.m_8055_(blockpos);
                VoxelShape voxelshape = blockstate.m_60812_((BlockGetter)mob.f_19853_, blockpos);
                if (d2 > (double)mob.f_19793_ && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, mob.m_20205_()) || !voxelshape.m_83281_() && mob.m_20186_() < voxelshape.m_83297_(Direction.Axis.Y) + (double)blockpos.m_123342_() && !blockstate.m_204336_(BlockTags.f_13103_) && !blockstate.m_204336_(BlockTags.f_13039_)) {
                    mob.m_21569_().m_24901_();
                    this.f_24981_ = MoveControl.Operation.JUMPING;
                }
                return;
            }
            super.m_8126_();
        }
    }
}

