/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle;

import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.endimator.TimedEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.api.entity.pathfinding.EndergeticFlyingPathNavigator;
import com.teamabnormals.endergetic.common.entity.eetle.AbstractEetle;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleBiteGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleDiveGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleDropOffGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleFleeAttackerGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleFlyGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleGrabGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleHoverNearTargetGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleLandGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleLookRandomlyGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleMunchGoal;
import com.teamabnormals.endergetic.common.entity.eetle.ai.glider.GliderEetleTakeoffGoal;
import com.teamabnormals.endergetic.common.entity.eetle.flying.FlyingEetleMoveController;
import com.teamabnormals.endergetic.common.entity.eetle.flying.FlyingRotations;
import com.teamabnormals.endergetic.common.entity.eetle.flying.IFlyingEetle;
import com.teamabnormals.endergetic.common.entity.eetle.flying.TargetFlyingRotations;
import com.teamabnormals.endergetic.core.registry.other.EEDataProcessors;
import com.teamabnormals.endergetic.core.registry.other.EEDataSerializers;
import com.teamabnormals.endergetic.core.registry.other.EEPlayableEndimations;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GliderEetle
extends AbstractEetle
implements IFlyingEetle {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(GliderEetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.m_135353_(GliderEetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIVING = SynchedEntityData.m_135353_(GliderEetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<TargetFlyingRotations> TARGET_FLYING_ROTATIONS = SynchedEntityData.m_135353_(GliderEetle.class, EEDataSerializers.TARGET_FLYING_ROTATIONS);
    private static final EntityDataAccessor<EntityDimensions> CAUGHT_SIZE = SynchedEntityData.m_135353_(GliderEetle.class, EEDataSerializers.ENTITY_SIZE);
    public static final EntityDimensions DEFAULT_SIZE = EntityDimensions.m_20398_((float)1.0f, (float)0.85f);
    public static final AttributeModifier CAUGHT_KNOCKBACK_RESISTANCE = new AttributeModifier(UUID.fromString("17da0b48-6e5f-11eb-9439-0242ac130002"), "Caught target knockback resistance", (double)0.8f, AttributeModifier.Operation.ADDITION);
    private final TimedEndimation takeoffEndimation = new TimedEndimation(15, 0);
    private final TimedEndimation flyingEndimation = new TimedEndimation(20, 0);
    private final FlyingRotations flyingRotations = new FlyingRotations();
    private GliderEetleLandGoal landGoal;
    private GliderEetleTakeoffGoal takeoffGoal;
    private GliderEetleFlyGoal flyGoal;
    private GliderEetleGrabGoal grabGoal;
    private GliderEetleFleeAttackerGoal fleeAttackerGoal;
    private GliderEetleHoverNearTargetGoal hoverNearTargetGoal;
    private GliderEetleMunchGoal munchGoal;
    private GliderEetleDropOffGoal dropOffGoal;
    private GliderEetleBiteGoal biteGoal;
    private GliderEetleDiveGoal diveGoal;
    @Nullable
    public LivingEntity groundedAttacker;
    private boolean takeoffMoving;
    private int flyCooldown;
    private int ticksFlown;
    private int groundedTimer;
    private float prevWingFlap = this.wingFlap = this.f_19796_.m_188501_();
    private float wingFlap;
    private float wingFlapSpeed;
    private float damageTakenWhileFlying;

    public GliderEetle(EntityType<? extends AbstractEetle> type, Level world) {
        super(type, world);
        this.takeoffEndimation.setDecrementing(true);
        this.flyingEndimation.setDecrementing(true);
        this.resetFlyCooldown();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(MOVING, (Object)false);
        this.f_19804_.m_135372_(DIVING, (Object)false);
        this.f_19804_.m_135372_(TARGET_FLYING_ROTATIONS, (Object)TargetFlyingRotations.ZERO);
        this.f_19804_.m_135372_(CAUGHT_SIZE, (Object)DEFAULT_SIZE);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (FLYING.equals(key)) {
            if (!this.m_6162_() && this.isFlying()) {
                this.f_21342_ = new FlyingEetleMoveController<GliderEetle>(this, 16.0f, 50.0f);
                this.f_21344_ = new EndergeticFlyingPathNavigator((Mob)this, this.f_19853_);
            } else {
                if (!this.m_6162_()) {
                    for (Entity passenger : this.m_20197_()) {
                        BlockPos pos;
                        passenger.m_6038_();
                        Level world = this.f_19853_;
                        if (!(passenger instanceof LivingEntity) || passenger.m_20202_() == this || world.f_46443_) continue;
                        AABB passengerBoundingBox = passenger.m_20191_();
                        double xSize = passengerBoundingBox.m_82362_();
                        double zSize = passengerBoundingBox.m_82385_();
                        AABB detectionBox = AABB.m_165882_((Vec3)passenger.m_20318_(0.0f), (double)(xSize * (double)0.8f), (double)0.2f, (double)(zSize * (double)0.8f));
                        if (world.m_45756_(passenger, detectionBox) || GliderEetle.hasCollisionsAbove(world, (pos = passenger.m_20183_()).m_122032_(), GliderEetle.getEntitySizeBlocksCeil(passenger))) continue;
                        passenger.m_6034_(passenger.m_20185_(), (double)((float)pos.m_123342_() + 1.0f), passenger.m_20189_());
                    }
                }
                this.idleDelay = this.f_19796_.m_188503_(41) + 30;
                this.f_21342_ = new AbstractEetle.GroundEetleMoveController((Mob)this);
                this.f_21344_ = this.m_6037_(this.f_19853_);
            }
        } else if (TARGET_FLYING_ROTATIONS.equals(key)) {
            this.flyingRotations.setLooking(true);
        } else if (CAUGHT_SIZE.equals(key)) {
            this.m_6210_();
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.diveGoal = new GliderEetleDiveGoal(this);
        this.f_21345_.m_25352_(1, (Goal)this.diveGoal);
        this.dropOffGoal = new GliderEetleDropOffGoal(this);
        this.f_21345_.m_25352_(1, (Goal)this.dropOffGoal);
        this.biteGoal = new GliderEetleBiteGoal(this);
        this.f_21345_.m_25352_(2, (Goal)this.biteGoal);
        this.grabGoal = new GliderEetleGrabGoal(this);
        this.f_21345_.m_25352_(2, (Goal)this.grabGoal);
        this.munchGoal = new GliderEetleMunchGoal(this);
        this.f_21345_.m_25352_(2, (Goal)this.munchGoal);
        this.hoverNearTargetGoal = new GliderEetleHoverNearTargetGoal(this);
        this.f_21345_.m_25352_(2, (Goal)this.hoverNearTargetGoal);
        this.fleeAttackerGoal = new GliderEetleFleeAttackerGoal(this);
        this.f_21345_.m_25352_(3, (Goal)this.fleeAttackerGoal);
        this.landGoal = new GliderEetleLandGoal(this);
        this.f_21345_.m_25352_(3, (Goal)this.landGoal);
        this.takeoffGoal = new GliderEetleTakeoffGoal(this);
        this.f_21345_.m_25352_(4, (Goal)this.takeoffGoal);
        this.flyGoal = new GliderEetleFlyGoal(this);
        this.f_21345_.m_25352_(5, (Goal)this.flyGoal);
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(7, (Goal)new GliderEetleLookRandomlyGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f){

            public boolean m_8036_() {
                return this.f_25512_.m_20197_().isEmpty() && super.m_8036_();
            }

            public boolean m_8045_() {
                return this.f_25512_.m_20197_().isEmpty() && super.m_8045_();
            }
        });
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22280_, (double)0.35f).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22277_, 28.0).m_22268_(Attributes.f_22278_, (double)0.2f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            AttributeInstance knockbackResistance = this.m_21051_(Attributes.f_22278_);
            if (knockbackResistance != null) {
                boolean noPassengers = this.m_20197_().isEmpty();
                boolean hasModifier = knockbackResistance.m_22109_(CAUGHT_KNOCKBACK_RESISTANCE);
                if (noPassengers && hasModifier || this.m_6162_()) {
                    knockbackResistance.m_22130_(CAUGHT_KNOCKBACK_RESISTANCE);
                } else if (!noPassengers && !hasModifier) {
                    knockbackResistance.m_22118_(CAUGHT_KNOCKBACK_RESISTANCE);
                }
            }
            if (!this.m_6162_()) {
                if (this.flyCooldown > 0) {
                    --this.flyCooldown;
                }
                if (this.isFlying()) {
                    ++this.ticksFlown;
                    if (this.isGrounded()) {
                        this.setFlying(false);
                    }
                } else {
                    this.ticksFlown = 0;
                }
                if (this.f_19796_.m_188501_() < 0.005f && this.idleDelay <= 0 && !this.isFlying() && this.m_5448_() == null && this.isNoEndimationPlaying()) {
                    NetworkUtil.setPlayingAnimation((Entity)this, (PlayableEndimation)(this.f_19796_.m_188501_() < 0.6f ? EEPlayableEndimations.GLIDER_EETLE_FLAP : EEPlayableEndimations.GLIDER_EETLE_MUNCH));
                    this.resetIdleFlapDelay();
                }
            }
            if (this.isGrounded()) {
                --this.groundedTimer;
                if (this.groundedTimer <= 0) {
                    this.groundedAttacker = null;
                }
            }
            if (this.isDiving()) {
                this.setDiving(false);
            }
        } else {
            if (!this.m_6162_()) {
                TimedEndimation takeoff = this.takeoffEndimation;
                takeoff.tick();
                if (takeoff.isMaxed()) {
                    this.takeoffMoving = true;
                    takeoff.setDecrementing(true);
                } else if (this.takeoffMoving) {
                    this.takeoffMoving = takeoff.getTick() > 15;
                } else {
                    takeoff.setDecrementing(!this.isFlying());
                }
                TimedEndimation flying = this.flyingEndimation;
                flying.tick();
                boolean moving = this.isMoving();
                flying.setDecrementing(!moving);
                this.wingFlapSpeed += moving ? (0.5f - this.wingFlapSpeed) * 0.1f : (0.125f - this.wingFlapSpeed) * 0.2f;
                this.prevWingFlap = this.wingFlap;
                this.wingFlap += this.wingFlapSpeed;
            }
            this.flyingRotations.tick(this.getTargetFlyingRotations());
        }
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && !this.m_6162_() && this.isFlying()) {
            this.m_19920_(0.1f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(this.isDiving() ? (double)0.95f : (double)0.8f));
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.01, 0.0));
        } else {
            super.m_7023_(travelVector);
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("FlyCooldown", this.flyCooldown);
        compound.m_128379_("IsFlying", this.isFlying());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.flyCooldown = compound.m_128451_("FlyCooldown");
        this.setFlying(compound.m_128471_("IsFlying"));
    }

    @Override
    public void m_6863_(boolean child) {
        super.m_6863_(child);
        if (child) {
            this.setFlying(false);
        }
    }

    @Override
    protected void updateGoals(GoalSelector goalSelector, GoalSelector targetSelector, boolean child) {
        super.updateGoals(goalSelector, targetSelector, child);
        if (child) {
            goalSelector.m_25363_((Goal)this.landGoal);
            goalSelector.m_25363_((Goal)this.takeoffGoal);
            goalSelector.m_25363_((Goal)this.flyGoal);
            goalSelector.m_25363_((Goal)this.grabGoal);
            goalSelector.m_25363_((Goal)this.fleeAttackerGoal);
            goalSelector.m_25363_((Goal)this.hoverNearTargetGoal);
            goalSelector.m_25363_((Goal)this.munchGoal);
            goalSelector.m_25363_((Goal)this.dropOffGoal);
            goalSelector.m_25363_((Goal)this.biteGoal);
            goalSelector.m_25363_((Goal)this.diveGoal);
        } else {
            goalSelector.m_25352_(3, (Goal)this.landGoal);
            goalSelector.m_25352_(4, (Goal)this.takeoffGoal);
            goalSelector.m_25352_(5, (Goal)this.flyGoal);
            goalSelector.m_25352_(2, (Goal)this.grabGoal);
            goalSelector.m_25352_(3, (Goal)this.fleeAttackerGoal);
            goalSelector.m_25352_(2, (Goal)this.hoverNearTargetGoal);
            goalSelector.m_25352_(2, (Goal)this.munchGoal);
            goalSelector.m_25352_(1, (Goal)this.dropOffGoal);
            goalSelector.m_25352_(2, (Goal)this.biteGoal);
            goalSelector.m_25352_(1, (Goal)this.diveGoal);
        }
    }

    public void m_7332_(Entity passenger) {
        this.m_5618_(this.m_146908_());
        if (this.m_20363_(passenger)) {
            if (passenger instanceof LivingEntity && !GliderEetle.isEntityLarge(passenger)) {
                AABB boundingBox = passenger.m_20191_();
                float y = (float)(boundingBox.f_82292_ - boundingBox.f_82289_) * -0.25f;
                float pitch = this.flyingRotations.getFlyPitch();
                Vec3 riderPos = new Vec3(0.8 + (double)Math.abs(pitch * 0.002f), (double)y, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f).m_82496_(pitch * ((float)Math.PI / 180));
                passenger.m_6034_(this.m_20185_() + riderPos.f_82479_, this.m_20186_() + 0.25 + riderPos.f_82480_, this.m_20189_() + riderPos.f_82481_);
            } else {
                super.m_7332_(passenger);
            }
        }
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (!this.f_19853_.f_46443_ && passenger instanceof LivingEntity && passenger.m_20202_() == this && this.m_20197_().indexOf(passenger) == 0) {
            this.setCaughtSize(EntityDimensions.m_20398_((float)(1.0f + passenger.m_6972_((Pose)passenger.m_20089_()).f_20377_), (float)0.85f));
        }
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (passenger.m_20202_() != this && passenger instanceof IDataManager) {
            IDataManager dataManager = (IDataManager)passenger;
            dataManager.setValue(EEDataProcessors.CATCHING_COOLDOWN, (Object)((Integer)dataManager.getValue(EEDataProcessors.CATCHING_COOLDOWN) + 40 + this.f_19796_.m_188503_(11)));
        }
        if (!this.f_19853_.f_46443_) {
            if (!this.m_20197_().isEmpty()) {
                Entity indexZeroPassenger = (Entity)this.m_20197_().get(0);
                if (indexZeroPassenger instanceof LivingEntity && passenger.m_20202_() == this) {
                    this.setCaughtSize(EntityDimensions.m_20398_((float)(1.0f + passenger.m_6972_((Pose)passenger.m_20089_()).f_20377_), (float)0.85f));
                } else {
                    this.setCaughtSize(DEFAULT_SIZE);
                }
            } else {
                this.setCaughtSize(DEFAULT_SIZE);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        float prevHealth = this.m_21223_();
        if (super.m_6469_(source, amount)) {
            Entity attacker = source.m_7639_();
            if (attacker instanceof LivingEntity && this.isFlying() && !this.m_20197_().isEmpty()) {
                this.damageTakenWhileFlying += Math.max(prevHealth - this.m_21223_() - (float)this.f_19796_.m_188503_(3), 0.0f);
                if (this.damageTakenWhileFlying >= 16.0f) {
                    this.damageTakenWhileFlying = 0.0f;
                    this.groundedAttacker = (LivingEntity)attacker;
                    this.makeGrounded();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public EntityDimensions m_6972_(Pose poseIn) {
        if (!this.m_6162_() && !this.m_20197_().isEmpty()) {
            return this.getCaughtSize();
        }
        return super.m_6972_(poseIn);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void makeGrounded() {
        this.groundedTimer = this.f_19796_.m_188503_(41) + 80;
        this.setFlying(false);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
        if (!flying) {
            this.setMoving(false);
        }
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    @Override
    public void setMoving(boolean moving) {
        this.f_19804_.m_135381_(MOVING, (Object)moving);
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(MOVING);
    }

    public void setDiving(boolean diving) {
        this.f_19804_.m_135381_(DIVING, (Object)diving);
    }

    public boolean isDiving() {
        return (Boolean)this.f_19804_.m_135370_(DIVING);
    }

    @Override
    public void setTargetFlyingRotations(TargetFlyingRotations flyingRotations) {
        this.f_19804_.m_135381_(TARGET_FLYING_ROTATIONS, (Object)flyingRotations);
    }

    public TargetFlyingRotations getTargetFlyingRotations() {
        return (TargetFlyingRotations)this.f_19804_.m_135370_(TARGET_FLYING_ROTATIONS);
    }

    public void setCaughtSize(EntityDimensions size) {
        this.f_19804_.m_135381_(CAUGHT_SIZE, (Object)size);
    }

    public EntityDimensions getCaughtSize() {
        return (EntityDimensions)this.f_19804_.m_135370_(CAUGHT_SIZE);
    }

    public FlyingRotations getFlyingRotations() {
        return this.flyingRotations;
    }

    public void resetFlyCooldown() {
        this.flyCooldown = this.f_19796_.m_188503_(301) + 100;
    }

    public boolean canFly() {
        return this.flyCooldown <= 0;
    }

    public boolean isGrounded() {
        return this.groundedTimer > 0;
    }

    public boolean shouldLand() {
        return this.m_20197_().isEmpty() && this.ticksFlown >= 30;
    }

    public float getTakeoffProgress() {
        return this.takeoffEndimation.getProgress(ClientInfo.getPartialTicks());
    }

    public float getFlyingProgress() {
        return this.flyingEndimation.getProgress(ClientInfo.getPartialTicks());
    }

    public float getWingFlap() {
        return Mth.m_14179_((float)ClientInfo.getPartialTicks(), (float)this.prevWingFlap, (float)this.wingFlap);
    }

    public static boolean isEntityLarge(Entity entity) {
        return entity.m_20191_().m_82309_() >= (double)1.3f;
    }

    private static int getEntitySizeBlocksCeil(Entity entity) {
        return (int)Math.ceil(entity.m_20191_().m_82376_());
    }

    private static boolean hasCollisionsAbove(Level world, BlockPos.MutableBlockPos mutable, int blocksAbove) {
        int y = mutable.m_123342_();
        for (int i = 1; i <= blocksAbove; ++i) {
            mutable.m_142448_(y + i);
            if (world.m_8055_((BlockPos)mutable).m_60812_((BlockGetter)world, (BlockPos)mutable).m_83281_()) continue;
            return true;
        }
        return false;
    }
}

