/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle.ai.brood;

import com.teamabnormals.blueprint.core.endimator.entity.EndimatedGoal;
import com.teamabnormals.endergetic.common.entity.eetle.AbstractEetle;
import com.teamabnormals.endergetic.common.entity.eetle.BroodEetle;
import com.teamabnormals.endergetic.common.entity.eetle.ai.brood.BroodEetleFlingGoal;
import com.teamabnormals.endergetic.core.registry.EEParticleTypes;
import com.teamabnormals.endergetic.core.registry.other.EEPlayableEndimations;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BroodEetleSlamGoal
extends EndimatedGoal<BroodEetle> {
    public BroodEetleSlamGoal(BroodEetle entity) {
        super((Entity)entity, EEPlayableEndimations.BROOD_EETLE_SLAM);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        BroodEetle broodEetle = (BroodEetle)this.entity;
        if (broodEetle.isFiringCannon()) {
            return false;
        }
        return broodEetle.canSlam() && broodEetle.m_20096_() && broodEetle.isNoEndimationPlaying() && BroodEetleFlingGoal.searchForNearbyAggressors(broodEetle, 3.0).size() > 3 || broodEetle.shouldSlamWhenWakingUp();
    }

    public void m_8056_() {
        this.playEndimation();
        BroodEetle broodEetle = (BroodEetle)this.entity;
        broodEetle.wokenUpAggressively = false;
        broodEetle.resetSlamCooldown();
    }

    public boolean m_8045_() {
        return this.isEndimationPlaying();
    }

    public void m_8037_() {
        if (this.isEndimationAtTick(14)) {
            BroodEetleSlamGoal.slam((BroodEetle)this.entity, ((BroodEetle)this.entity).m_217043_(), 1.0f);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public static void slam(BroodEetle broodEetle, RandomSource random, float power) {
        ServerLevel world = (ServerLevel)broodEetle.f_19853_;
        double posX = broodEetle.m_20185_();
        double posY = broodEetle.m_20186_();
        double posZ = broodEetle.m_20189_();
        for (BlockState state : BroodEetleSlamGoal.sampleGround((Level)world, broodEetle.m_20183_().m_7495_(), random)) {
            world.m_8767_((ParticleOptions)new BlockParticleOption((ParticleType)EEParticleTypes.FAST_BLOCK.get(), state), posX, posY, posZ, 8, 0.0, 0.0, 0.0, (double)0.225f);
        }
        float attackDamage = (float)broodEetle.m_21133_(Attributes.f_22281_) * power;
        double knockback = broodEetle.m_21133_(Attributes.f_22282_);
        for (LivingEntity livingEntity : world.m_6443_(LivingEntity.class, broodEetle.m_20191_().m_82400_(4.5), entity1 -> entity1 != broodEetle)) {
            float damage = (float)((int)attackDamage) > 0.0f ? attackDamage / 2.0f + (float)random.m_188503_((int)attackDamage) : attackDamage;
            if (livingEntity instanceof AbstractEetle) {
                damage = 0.0f;
            }
            if (!livingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)broodEetle), damage)) continue;
            broodEetle.m_19970_((LivingEntity)broodEetle, (Entity)livingEntity);
            double knockbackForce = knockback - livingEntity.m_21133_(Attributes.f_22278_);
            float inAirFactor = livingEntity.m_20096_() ? 1.0f : 0.75f;
            Vec3 horizontalVelocity = new Vec3(livingEntity.m_20185_() - posX, 0.0, livingEntity.m_20189_() - posZ).m_82541_().m_82490_(knockbackForce * (double)(random.m_188501_() * 0.75f + 0.5f) * (double)inAirFactor * (double)power);
            livingEntity.m_5997_(horizontalVelocity.f_82479_, knockbackForce * 0.5 * (double)random.m_188501_() * 0.5 * (double)inAirFactor, horizontalVelocity.f_82481_);
            livingEntity.f_19864_ = true;
        }
    }

    private static List<BlockState> sampleGround(Level world, BlockPos groundPos, RandomSource random) {
        ArrayList<BlockState> list = new ArrayList<BlockState>();
        int originX = groundPos.m_123341_();
        int originY = groundPos.m_123342_();
        int originZ = groundPos.m_123343_();
        BlockPos.MutableBlockPos mutable = groundPos.m_122032_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockState state = world.m_8055_((BlockPos)mutable.m_122178_(originX + x, originY, originZ + z));
                if (state.m_60795_()) continue;
                list.add(state);
            }
        }
        if (!list.isEmpty()) {
            while (list.size() < 9) {
                list.add((BlockState)list.get(random.m_188503_(list.size())));
            }
        }
        return list;
    }
}

