/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle.ai.charger;

import com.teamabnormals.endergetic.common.entity.eetle.ChargerEetle;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class EetleMeleeAttackGoal
extends Goal {
    private final ChargerEetle attacker;
    private Path path;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int delayCounter;
    private int meleeCooldown;

    public EetleMeleeAttackGoal(ChargerEetle charger) {
        this.attacker = charger;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        this.path = this.attacker.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.attacker.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public void m_8056_() {
        this.attacker.m_21573_().m_26536_(this.path, 1.25);
        this.attacker.m_21561_(true);
        this.delayCounter = 0;
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        return !this.attacker.m_21573_().m_26571_();
    }

    public void m_8037_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        this.attacker.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
        double d0 = this.attacker.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        this.delayCounter = Math.max(this.delayCounter - 1, 0);
        if (this.attacker.m_21574_().m_148306_((Entity)livingentity) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.m_217043_().m_188501_() < 0.05f)) {
            this.targetX = livingentity.m_20185_();
            this.targetY = livingentity.m_20186_();
            this.targetZ = livingentity.m_20189_();
            this.delayCounter = 4 + this.attacker.m_217043_().m_188503_(7);
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.m_21573_().m_5624_((Entity)livingentity, 1.25)) {
                this.delayCounter += 15;
            }
        }
        if (this.meleeCooldown > 0) {
            --this.meleeCooldown;
        } else {
            this.checkAndPerformAttack(livingentity, d0);
        }
    }

    public void m_8041_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.attacker.m_6710_(null);
        }
        this.attacker.m_21561_(false);
        this.attacker.m_21573_().m_26573_();
    }

    private void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        ChargerEetle attacker = this.attacker;
        if (attacker.isNoEndimationPlaying() && distToEnemySqr <= this.getAttackReachSqr(enemy) && attacker.m_142582_((Entity)enemy)) {
            attacker.m_7327_((Entity)enemy);
            this.meleeCooldown += 10 + attacker.m_217043_().m_188503_(11);
        }
    }

    private double getAttackReachSqr(LivingEntity attackTarget) {
        float widthDoubled = this.attacker.m_20205_() * 2.0f;
        return widthDoubled * widthDoubled + attackTarget.m_20205_();
    }

    public boolean m_183429_() {
        return true;
    }
}

