/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.puffbug.ai;

import com.teamabnormals.endergetic.common.block.entity.BolloomBudTileEntity;
import com.teamabnormals.endergetic.common.block.poise.BolloomBudBlock;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.other.EEPlayableEndimations;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PuffBugTeleportToBudGoal
extends Goal {
    private static final int AREA_CHECK_SIZE = 26;
    private PuffBug puffbug;
    private Level world;

    public PuffBugTeleportToBudGoal(PuffBug puffbug) {
        this.puffbug = puffbug;
        this.world = puffbug.f_19853_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        BlockPos pos;
        BolloomBudTileEntity bud;
        if (!this.puffbug.m_20159_() && this.puffbug.m_5448_() == null && this.puffbug.isNoEndimationPlaying() && this.puffbug.m_217043_().m_188503_(100) == 0 && !this.puffbug.hasLevitation() && !this.puffbug.m_27593_() && !this.puffbug.wantsToRest() && this.puffbug.getTeleportController().canTeleport() && (bud = this.findNearbyBud()) != null && (pos = this.createUpperPosition(bud.m_58899_())) != null && this.puffbug.getTeleportController().tryToCreateDesinationTo(pos, null)) {
            bud.setTeleportingBug(this.puffbug);
            this.puffbug.setBudPos(bud.m_58899_());
            return true;
        }
        return false;
    }

    public void m_8056_() {
        this.puffbug.getTeleportController().processTeleportation();
        this.puffbug.m_20256_(Vec3.f_82478_);
    }

    public void m_8037_() {
        this.puffbug.m_20256_(Vec3.f_82478_);
    }

    public boolean m_8045_() {
        return !this.puffbug.m_27593_() && this.puffbug.isEndimationPlaying(EEPlayableEndimations.PUFF_BUG_TELEPORT_TO);
    }

    @Nullable
    private BolloomBudTileEntity findNearbyBud() {
        BlockPos pos = this.puffbug.m_20183_();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-26, -13, -26), (BlockPos)pos.m_7918_(26, 13, 26))) {
            BolloomBudTileEntity bud;
            if (!blockpos.m_203195_((Position)this.puffbug.m_20182_(), 26.0) || this.world.m_8055_(blockpos).m_60734_() != EEBlocks.BOLLOOM_BUD.get() || !(this.world.m_7702_(blockpos) instanceof BolloomBudTileEntity) || ((Boolean)(bud = (BolloomBudTileEntity)this.world.m_7702_(blockpos)).m_58900_().m_61143_((Property)BolloomBudBlock.OPENED)).booleanValue() || !this.isPathNotBlockedByEntity(bud) || bud.hasTeleportingBug() || !bud.canBeOpened()) continue;
            return bud;
        }
        return null;
    }

    @Nullable
    private BlockPos createUpperPosition(BlockPos pos) {
        BlockPos foundPos = null;
        for (int y = 1; y < 3; ++y) {
            if (!this.world.m_8055_(pos.m_6630_(y)).m_60812_((BlockGetter)this.world, pos).m_83281_() || !this.world.m_6425_(pos.m_6630_(y)).m_76178_()) {
                foundPos = null;
                break;
            }
            foundPos = pos.m_6630_(y);
        }
        return foundPos;
    }

    private boolean isPathNotBlockedByEntity(BolloomBudTileEntity bud) {
        return this.world.m_45976_(Entity.class, new AABB(bud.m_58899_()).m_82363_(0.0, 3.0, 0.0)).isEmpty();
    }

    public boolean m_183429_() {
        return true;
    }
}

