/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.purpoid.ai;

import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.other.EEPlayableEndimations;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.Vec3;

public class PurpazoidSquirtPurpsGoal
extends Goal {
    private final Purpoid purpoid;
    private int ticksWhileWaiting;
    private Vec3 chosenDirection = Vec3.f_82478_;
    private List<LivingEntity> nearbyRevengeTargets = new ArrayList<LivingEntity>();

    public PurpazoidSquirtPurpsGoal(Purpoid purpoid) {
        this.purpoid = purpoid;
        this.m_7021_(EnumSet.allOf(Goal.Flag.class));
    }

    public boolean m_8036_() {
        Purpoid purpoid = this.purpoid;
        if (!purpoid.wantsToFlee() && purpoid.getStunTimer() <= 0 && purpoid.isNoEndimationPlaying() && !purpoid.getTeleportController().isTeleporting()) {
            List nearbyRevengeTargets;
            if (++this.ticksWhileWaiting < 10) {
                return false;
            }
            Set<UUID> revengeTargets = purpoid.revengeTargets;
            if (!revengeTargets.isEmpty() && !(nearbyRevengeTargets = purpoid.f_19853_.m_6443_(LivingEntity.class, purpoid.m_20191_().m_82400_(32.0), entity -> TargetingConditions.f_26872_.m_26885_((LivingEntity)purpoid, entity) && revengeTargets.contains(entity.m_20148_()))).isEmpty()) {
                Vec3 positionOfRandomNearbyRevengeTarget = ((LivingEntity)nearbyRevengeTargets.get(purpoid.m_217043_().m_188503_(nearbyRevengeTargets.size()))).m_20182_();
                Vec3 direction = purpoid.m_20182_().m_82546_(positionOfRandomNearbyRevengeTarget).m_82541_();
                double y = direction.m_7098_();
                this.chosenDirection = y < 0.0 ? new Vec3(direction.m_7096_(), -y, direction.m_7094_()) : direction;
                this.nearbyRevengeTargets = nearbyRevengeTargets;
                return true;
            }
        }
        this.ticksWhileWaiting = 0;
        return false;
    }

    public void m_8056_() {
        Purpoid purpoid = this.purpoid;
        NetworkUtil.setPlayingAnimation((Entity)purpoid, (PlayableEndimation)EEPlayableEndimations.PURPOID_SQUIRT_ATTACK);
        purpoid.m_7910_(0.0f);
        purpoid.m_21573_().m_26573_();
    }

    public boolean m_8045_() {
        if (!this.purpoid.isEndimationPlaying(EEPlayableEndimations.PURPOID_SQUIRT_ATTACK)) {
            this.purpoid.setStunTimer(600 + this.purpoid.m_217043_().m_188503_(101));
            return false;
        }
        return true;
    }

    public void m_8037_() {
        Purpoid purpoid = this.purpoid;
        purpoid.m_7910_(0.0f);
        purpoid.m_21573_().m_26573_();
        int animationTick = purpoid.getAnimationTick();
        float velocityScale = 0.0333f;
        if (animationTick >= 40) {
            Purpoid purp;
            velocityScale = 0.2f;
            if (animationTick % 4 == 0 && (purp = (Purpoid)((EntityType)EEEntityTypes.PURPOID.get()).m_20615_(purpoid.f_19853_)) != null) {
                purp.updateAge(-24000);
                Vec3 deltaMovement = purpoid.m_20184_();
                purp.m_7678_(purpoid.m_20185_() - 4.0 * deltaMovement.m_7096_(), purpoid.m_20186_() + 0.75 - 4.0 * deltaMovement.m_7098_(), purpoid.m_20189_() - 4.0 * deltaMovement.m_7094_(), 0.0f, 0.0f);
                RandomSource random = purpoid.m_217043_();
                purp.m_20256_(deltaMovement.m_82520_(random.m_216328_(0.0, 1.0), 0.0, random.m_216328_(0.0, 1.0)).m_82490_(-2.0));
                purp.m_6710_(this.nearbyRevengeTargets.get(random.m_188503_(this.nearbyRevengeTargets.size())));
                purp.randomizeDespawnTimer();
                if (random.m_188501_() < 0.143f || animationTick >= 56 && purpoid.needsMoreShielders()) {
                    purpoid.addShielder(purp);
                }
                purpoid.f_19853_.m_7967_((Entity)purp);
            }
        }
        purpoid.m_20256_(purpoid.m_20184_().m_82549_(this.chosenDirection.m_82490_((double)velocityScale)));
    }

    public void m_8041_() {
        this.chosenDirection = Vec3.f_82478_;
        this.ticksWhileWaiting = 0;
        this.nearbyRevengeTargets.clear();
    }

    public boolean m_183429_() {
        return true;
    }
}

