/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.purpoid.ai;

import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.common.network.entity.S2CEnablePurpoidFlash;
import com.teamabnormals.endergetic.core.EndergeticExpansion;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;

public class PurpoidTelefragGoal
extends Goal {
    private final Purpoid purpoid;
    @Nullable
    private TeleportPattern teleportPattern;

    public PurpoidTelefragGoal(Purpoid purpoid) {
        this.purpoid = purpoid;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        Purpoid purpoid = this.purpoid;
        Entity ridingEntity = purpoid.m_20202_();
        return purpoid.isNoEndimationPlaying() && !purpoid.getTeleportController().isTeleporting() && ridingEntity instanceof LivingEntity && ridingEntity.m_6084_() && (!(ridingEntity instanceof Player) || !ridingEntity.m_5833_() && !((Player)ridingEntity).m_7500_());
    }

    public void m_8056_() {
        Purpoid purpoid = this.purpoid;
        this.teleportPattern = new TeleportPattern(purpoid.m_217043_());
        purpoid.m_6710_((LivingEntity)purpoid.m_20202_());
        purpoid.m_21561_(true);
    }

    public void m_8037_() {
        Purpoid.TeleportController teleportController;
        Purpoid purpoid = this.purpoid;
        if (purpoid.isNoEndimationPlaying() && !(teleportController = purpoid.getTeleportController()).isTeleporting()) {
            boolean sky = this.teleportPattern.next();
            BlockPos teleportPos = null;
            BlockPos pos = purpoid.m_20183_();
            RandomSource random = purpoid.m_217043_();
            Level world = purpoid.f_19853_;
            Entity ridingEntity = purpoid.m_20202_();
            if (sky) {
                EntityDimensions size = purpoid.m_6972_(purpoid.m_20089_());
                for (int i = 0; i < 16; ++i) {
                    BlockPos randomPos = pos.m_7918_(random.m_188503_(32) - random.m_188503_(32), random.m_188503_(32) + 8, random.m_188503_(32) - random.m_188503_(32));
                    AABB collisionBox = size.m_20384_((double)((float)randomPos.m_123341_() + 0.5f), (double)randomPos.m_123342_(), (double)((float)randomPos.m_123343_() + 0.5f));
                    if (!world.m_46805_(randomPos) || !world.m_45772_(collisionBox) || world.m_46855_(collisionBox)) continue;
                    teleportPos = randomPos;
                    break;
                }
            } else {
                EntityDimensions size = ridingEntity.m_6972_(ridingEntity.m_20089_());
                int x = pos.m_123341_();
                int z = pos.m_123343_();
                for (int i = 0; i < 32; ++i) {
                    int y;
                    int randomX = x + (random.m_188503_(32) - random.m_188503_(32));
                    int randomZ = z + (random.m_188503_(32) - random.m_188503_(32));
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(randomX, (int)ridingEntity.m_20186_(), randomZ);
                    if (!world.m_46805_((BlockPos)mutable)) continue;
                    boolean successful = true;
                    while ((y = mutable.m_123342_()) > 0 && !world.m_8055_((BlockPos)mutable).m_60767_().m_76334_()) {
                        mutable.m_142448_(y - 1);
                    }
                    if (y <= 0) {
                        successful = false;
                    }
                    if (!successful) continue;
                    mutable.m_122173_(Direction.UP);
                    AABB collisionBox = size.m_20384_((double)((float)mutable.m_123341_() + 0.5f), (double)mutable.m_123342_(), (double)((float)mutable.m_123343_() + 0.5f));
                    if (!world.m_45772_(collisionBox) || world.m_46855_(collisionBox)) continue;
                    teleportPos = mutable;
                    break;
                }
            }
            if (teleportPos != null) {
                teleportController.beginTeleportation(purpoid, teleportPos, true);
                ridingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)purpoid), (float)purpoid.m_21133_(Attributes.f_22281_));
                if (ridingEntity instanceof ServerPlayer) {
                    EndergeticExpansion.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)ridingEntity), (Object)new S2CEnablePurpoidFlash());
                }
            }
        }
    }

    public boolean m_8045_() {
        Purpoid purpoid = this.purpoid;
        Entity ridingEntity = purpoid.m_20202_();
        return ridingEntity instanceof LivingEntity && ridingEntity.m_6084_() && (!(ridingEntity instanceof Player) || !ridingEntity.m_5833_() && !((Player)ridingEntity).m_7500_());
    }

    public void m_8041_() {
        this.teleportPattern = null;
        Purpoid purpoid = this.purpoid;
        LivingEntity livingentity = purpoid.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            purpoid.m_6710_(null);
        }
        purpoid.m_21561_(false);
    }

    public boolean m_183429_() {
        return true;
    }

    static class TeleportPattern {
        private final boolean[] sequence;
        private int index;

        TeleportPattern(RandomSource random) {
            if (random.m_188499_()) {
                boolean first = random.m_188499_();
                boolean second = random.m_188499_();
                boolean[] blArray = new boolean[3];
                blArray[0] = first;
                blArray[1] = second;
                blArray[2] = first == second ? !first : random.m_188499_();
                this.sequence = blArray;
            } else {
                boolean first = random.m_188499_();
                this.sequence = new boolean[]{first, !first};
            }
        }

        private boolean next() {
            boolean[] sequence = this.sequence;
            return sequence[this.index++ % sequence.length];
        }
    }
}

