/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.item;

import com.teamabnormals.blueprint.core.util.item.ItemStackUtil;
import com.teamabnormals.endergetic.client.model.armor.BoofloVestModel;
import com.teamabnormals.endergetic.core.registry.other.EEArmorMaterials;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class BoofloVestItem
extends ArmorItem {
    private static final String DEFAULT_TEXTURE = "endergetic:textures/models/armor/booflo_vest.png";
    private static final String BOOFED_TEXTURE = "endergetic:textures/models/armor/booflo_vest_boofed.png";
    public static final String TICKS_BOOFED_TAG = "ticksBoofed";
    public static final String BOOFED_TAG = "boofed";
    public static final String TIMES_BOOFED_TAG = "timesBoofed";

    public BoofloVestItem(Item.Properties properties) {
        super((ArmorMaterial)EEArmorMaterials.BOOFLO_VEST, EquipmentSlot.CHEST, properties);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        CompoundTag tag = stack.m_41784_();
        int ticksBoofed = tag.m_128451_(TICKS_BOOFED_TAG);
        if (tag.m_128471_(BOOFED_TAG)) {
            tag.m_128405_(TICKS_BOOFED_TAG, ++ticksBoofed);
        } else {
            tag.m_128405_(TICKS_BOOFED_TAG, 0);
        }
        if (ticksBoofed >= 10) {
            tag.m_128379_(BOOFED_TAG, false);
        }
        if (tag.m_128451_(TICKS_BOOFED_TAG) == 10) {
            player.m_6844_(EquipmentSlot.CHEST).m_41622_(2, (LivingEntity)player, onBroken -> onBroken.m_21166_(EquipmentSlot.CHEST));
        }
        if (player.m_20096_() || player.m_20159_() && player.m_20202_().m_20096_()) {
            tag.m_128405_(TIMES_BOOFED_TAG, 0);
        }
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        ItemStackUtil.fillAfterItemForCategory((Item)this, (Item)Items.f_42354_, (CreativeModeTab)group, items);
    }

    public boolean m_41465_() {
        return true;
    }

    public static boolean canBoof(ItemStack stack, Player player) {
        return !player.m_36335_().m_41519_(stack.m_41720_()) && !stack.m_41784_().m_128471_(BOOFED_TAG);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return stack.m_41782_() && stack.m_41783_().m_128471_(BOOFED_TAG) ? BOOFED_TEXTURE : DEFAULT_TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack stack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return stack.m_41782_() && stack.m_41783_().m_128471_(BoofloVestItem.BOOFED_TAG) ? BoofloVestModel.INSTANCE : original;
            }
        });
    }
}

