/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.endergetic.api.util.GenerationUtils;
import com.teamabnormals.endergetic.common.block.entity.BolloomBudTileEntity;
import com.teamabnormals.endergetic.common.block.poise.BolloomBudBlock;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BolloomBudFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState BOLLOOM_BUD = ((Block)EEBlocks.BOLLOOM_BUD.get()).m_49966_();

    public BolloomBudFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos;
        WorldGenLevel world = context.m_159774_();
        if (world.m_46859_(pos = context.m_159777_()) && world.m_46859_(pos.m_7494_())) {
            RandomSource rand = context.m_225041_();
            if ((double)rand.m_188501_() > 0.75) {
                if (BolloomBudFeature.isValidGround((LevelAccessor)world, pos)) {
                    world.m_7731_(pos, BOLLOOM_BUD, 2);
                    return true;
                }
            } else {
                int maxHeight = BolloomBudFeature.calculateFruitMaxHeight((LevelAccessor)world, pos);
                if (BolloomBudFeature.isValidGround((LevelAccessor)world, pos) && BolloomBudFeature.canFitCross((LevelAccessor)world, pos) && GenerationUtils.isAreaAir((LevelAccessor)world, pos.m_123341_() - 1, pos.m_123342_() + 1, pos.m_123343_() - 1, pos.m_123341_() + 1, pos.m_123342_() + 2, pos.m_123343_() + 1) && maxHeight > 1) {
                    world.m_7731_(pos, (BlockState)BOLLOOM_BUD.m_61124_((Property)BolloomBudBlock.OPENED, (Comparable)Boolean.valueOf(true)), 2);
                    BlockEntity te = world.m_7702_(pos);
                    if (te instanceof BolloomBudTileEntity) {
                        ((BolloomBudTileEntity)te).startGrowing(rand, maxHeight, true);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isValidGround(LevelAccessor world, BlockPos pos) {
        Block downBlock = world.m_8055_(pos.m_7495_()).m_60734_();
        return downBlock == EEBlocks.POISMOSS.get() || downBlock == EEBlocks.EUMUS_POISMOSS.get() || downBlock == EEBlocks.EUMUS.get();
    }

    private static int calculateFruitMaxHeight(LevelAccessor world, BlockPos pos) {
        int[] maxHeights = new int[4];
        for (BolloomBudTileEntity.BudSide sides : BolloomBudTileEntity.BudSide.values()) {
            int y = 1;
            while (y < 7 && world.m_46859_(sides.offsetPosition(pos.m_6630_(y)))) {
                maxHeights[sides.id] = y++;
            }
        }
        return MathUtil.getLowestValueInIntArray((int[])maxHeights);
    }

    private static boolean canFitCross(LevelAccessor world, BlockPos pos) {
        for (BolloomBudTileEntity.BudSide sides : BolloomBudTileEntity.BudSide.values()) {
            if (world.m_46859_(sides.offsetPosition(pos))) continue;
            return false;
        }
        return !BolloomBudBlock.isAcrossOrAdjacentToBud((LevelReader)world, pos);
    }
}

